from _modeller import get_topstr, get_topint, get_topreal, get_toplog, \
                      get_topdim, set_topstr, set_topint, set_topreal, \
                      set_toplog, set_topdim, topstr_macro
import topvar

def set_tops(logname, dictvars, defs, allowed):
  toset = {}
  logstring = "runcmd______> " + logname + '('
  first = True
  if type(allowed) is not tuple and type(allowed) is not list:
    allowed = (allowed,)
  for key in dictvars:
    if key not in allowed:
      raise SyntaxError, "Variable " + repr(key) + \
                         " is not valid for " + logname
    elif key != 'stop_on_error':
      if not first:
        logstring = logstring + ', '
      logstring = logstring + key + "=" + repr(dictvars[key])
      first = False
  if defs:
    defvars = dir(defs)
  else:
    defvars = []
  for key in allowed:
    if key not in dictvars:
      if key in defvars:
        if not first:
          logstring = logstring + ', '
        logstring = logstring + "(def)" + key + "=" + repr(eval("defs."+key))
        first = False
        toset[key] = eval("defs."+key)
      else:
        require_argument(key, logname)
  logstring = logstring + ')'
  log_output(logstring)
  set_topvars(dictvars)
  if len(toset) > 0:
    set_topvars(toset)

def log_output(logstring):
  out_control = get_topvars('output_control')
  if out_control[1] > 0:
    print logstring
    print

def require_argument(key, logname):
  raise SyntaxError, "A value must be given for " + repr(key) + \
                     " for " + logname

def get_topvars(toplist):
  if type(toplist) is not list and type(toplist) is not tuple:
    toplist = [ toplist ]
  retval = [];
  for name in toplist:
    (indx, typ, num) = topvar.topvars[name]
    dim = get_topdim(typ, indx)
    getfuncs = {'S': get_topstr, 'L': myget_toplog, 'R':  get_topreal,
                'I': get_topint }
    get_top = getfuncs[typ]
    topval = []
    for i in range(1,dim+1):
      topval.append(get_top(indx, i))
    if num == 1 and dim == 1:
      retval.append(topval[0])
    else:
      retval.append(tuple(topval))
  if (len(retval) == 1):
    return retval[0]
  else:
    return retval

def myget_toplog(indx, subindx):
  val = get_toplog(indx, subindx)
  if val == 0:
    return False
  else:
    return True

def set_topvars(topvardict):
  for name in topvardict.keys():
    value = topvardict[name]
    if value is None:
      continue
    (indx, typ, num) = topvar.topvars[name]
    setfuncs = { 'S': [ str, set_topstr, [int, float] ],
                 'L': [ bool, myset_toplog, [] ],
                 'R': [ float, set_topreal, [int] ],
                 'I': [ int, set_topint, [] ] }
    (top_type, top_set, top_oktypes) = setfuncs[typ]
    if num == 1:
      value = check_top_type(name, value, top_type, top_oktypes)
      set_topdim(typ, indx, 1)
      top_set(indx, 1, value)
    else:
      if type(value) is not list and type(value) is not tuple:
        value = [ check_top_type(name, value, top_type, top_oktypes) ]
      set_topdim(typ, indx, len(value))
      subindx = 0
      for val in value:
        val = check_top_type(name, val, top_type, top_oktypes)
        subindx = subindx + 1
        top_set(indx, subindx, val)
  for name in topvardict.keys():
    value = topvardict[name]
    if value is None:
      continue
    (indx, typ, num) = topvar.topvars[name]
    if typ == 'S':
      for subindx in range(num):
        topstr_macro(indx, subindx + 1)

def myset_toplog(indx, subindx, value):
  if value:
    val = 1
  else:
    val = 0
  set_toplog(indx, subindx, val)

def check_top_type(name, value, top_type, top_oktypes):
  if type(value) is not top_type:
    if type(value) in top_oktypes:
      value = top_type(value)
    else:
      raise TypeError, "Incorrect element type for variable %s" % (name.upper())
  return value

def handle_seq_indx(seqtype, indx):
  if type(indx) is int:
    if indx < 0:
      indx += len(seqtype)
    if indx < 0 or indx >= len(seqtype):
      raise IndexError
    else:
      return indx
  elif type(indx) is slice:
    rng = range_from_slice(indx, len(seqtype))
    slc = []
    for indx in rng:
      slc.append(seqtype[indx])
    return slc
  else:
    raise TypeError

def range_from_slice(slc, listlen):
  step = slc.step
  if step == None:
    step = 1
  if step > 0:
    start = getslcindx(slc.start, listlen, 0)
    stop = getslcindx(slc.stop, listlen, listlen)
  else:
    start = getslcindx(slc.start, listlen, listlen - 1)
    stop = getslcindx(slc.stop, listlen, -1)
  if start >= listlen:
    start = listlen - 1
  return range(start, stop, step)

def getslcindx(indx, listlen, default):
  if indx == None:
    return default
  if indx < 0:
    indx += listlen
  if indx < 0:
    indx = 0
  if indx > listlen:
    indx = listlen
  return indx

class modlist(object):
  def __init__(self, modpt, dim, getfunc, setfunc):
    self.__modpt = modpt
    self.__dim = dim
    self.__getfunc = getfunc
    self.__setfunc = setfunc

  def __len__(self):
    return self.__dim

  def __str__(self):
    return str([val for val in self])

  def __repr__(self):
    return str([val for val in self])

  def __getitem__(self, indx):
    ret = handle_seq_indx(self, indx)
    if type(ret) is int:
      return self.__getfunc(self.__modpt, ret)
    else:
      return ret

  def __setitem__(self, indx, val):
    return self.__setfunc(self.__modpt, indx, val)
