import top
from modeller.energy_data import energy_data
from modeller.io_data import io_data
import _modeller

class topcmds:
  aln = [None, None]
  mdl = [None, None]
  sdb = [None]
  prf = [None]
  tpl = [None]
  den = [None]
  edat = None
  io = None
  gprsr = None

  def get_edat(self):
    if self.edat == None:
      self.edat = energy_data()
    return self.edat

  def get_io(self):
    if self.io == None:
      self.io = io_data()
    return self.io

  def get_gprsr(self):
    if self.gprsr == None:
      self.gprsr = _modeller.new_group_restraints()
    return self.gprsr

  def get_aln(self, num=1):
    aln = self.aln[num - 1]
    if aln == None:
      aln = _modeller.new_alignment()
      self.aln[num - 1] = aln
    return aln

  def get_mdl(self, num=1):
    mdl = self.mdl[num - 1]
    if mdl == None:
      mdl = _modeller.new_model()
      _modeller.set_model_group_restraints(mdl, self.get_gprsr())
      self.mdl[num - 1] = mdl
    return mdl

  def get_sdb(self, num=1):
    sdb = self.sdb[num - 1]
    if sdb == None:
      sdb = _modeller.new_sequence_db()
      self.sdb[num - 1] = sdb
    return sdb

  def get_prf(self, num=1):
    prf = self.prf[num - 1]
    if prf == None:
      prf = _modeller.new_profile()
      self.prf[num - 1] = prf
    return prf

  def get_tpl(self, num=1):
    tpl = self.tpl[num - 1]
    if tpl == None:
      tpl = _modeller.new_topology()
      _modeller.use_topology(tpl)
      self.tpl[num - 1] = tpl
    return tpl

  def get_den(self, num=1):
    den = self.den[num - 1]
    if den == None:
      den = _modeller.new_density()
      self.den[num - 1] = den
    return den

  def delete_alignment(self):
    aln = self.get_aln()
    _modeller.delete_alignment(aln)

  def read_alignment2(self):
    aln2 = self.get_aln(2)
    io = self.get_io().modpt
    _modeller.read_alignment2(aln2, io)

  def read_model2(self):
    mdl2 = self.get_mdl(2)
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.read_model2(mdl2, aln, io)

  def write_model2(self):
    mdl2 = self.get_mdl(2)
    _modeller.write_model2(mdl2)

  def read_alignment(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.read_alignment(aln, io)

  def check_alignment(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.check_alignment(aln, io)

  def compare_alignments(self):
    aln = self.get_aln()
    aln2 = self.get_aln(2)
    _modeller.compare_alignments(aln, aln2)

  def sequence_to_ali(self):
    aln = self.get_aln()
    mdl = self.get_mdl()
    _modeller.sequence_to_ali(aln, mdl)

  def write_alignment(self):
    aln = self.get_aln()
    _modeller.write_alignment(aln)

  def edit_alignment(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.edit_alignment(aln, io)

  def describe(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.describe(aln, io)

  def id_table(self):
    aln = self.get_aln()
    _modeller.id_table(aln)

  def sequence_comparison(self):
    aln = self.get_aln()
    mdl = self.get_mdl()
    _modeller.sequence_comparison(aln, mdl)

  def align(self):
    aln = self.get_aln()
    _modeller.align(aln)

  def align2d(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.align2d(aln, io)

  def malign(self):
    aln = self.get_aln()
    _modeller.malign(aln)

  def align_consensus(self):
    aln = self.get_aln()
    _modeller.align_consensus(aln)

  def compare(self):
    aln = self.get_aln()
    edat = self.get_edat().modpt
    io = self.get_io().modpt
    _modeller.compare(aln, edat, io)

  def align3d(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.align3d(aln, io)

  def malign3d(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.malign3d(aln, io)

  def salign(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.salign(aln, io)

  def aln_to_prof(self):
    aln = self.get_aln()
    prf = self.get_prf()
    _modeller.aln_to_prof(aln, prf)

  def expand_alignment(self):
    aln = self.get_aln()
    _modeller.expand_alignment(aln)

  def segment_matching(self):
    aln = self.get_aln()
    _modeller.segment_matching(aln)

  def read_density(self):
    den = self.get_den()
    _modeller.read_density(den)

  def em_grid_search(self):
    den = self.get_den()
    _modeller.em_grid_search(den)

  def make_schedule(self):
    mdl = self.get_mdl()
    _modeller.make_schedule(mdl)

  def read_schedule(self):
    mdl = self.get_mdl()
    _modeller.read_schedule(mdl)

  def write_schedule(self):
    mdl = self.get_mdl()
    _modeller.write_schedule(mdl)

  def energy(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    _modeller.energy(mdl, edat)

  def optimize(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    _modeller.optimize(mdl, edat)

  def switch_trace(self):
    mdl = self.get_mdl()
    _modeller.switch_trace(mdl)

  def debug_function(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    _modeller.debug_function(mdl, edat)

  def assess_model(self):
    mdl = self.get_mdl()
    _modeller.assess_model(mdl)

  def assess_ga341(self):
    mdl = self.get_mdl()
    _modeller.assess_ga341(mdl)

  def read_atom_classes(self):
    gprsr = self.get_gprsr()
    _modeller.read_atom_classes(gprsr)

  def read_group_restraints(self):
    gprsr = self.get_gprsr()
    _modeller.read_group_restraints(gprsr)

  def read_model(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.read_model(mdl, aln, io)

  def write_model(self):
    mdl = self.get_mdl()
    _modeller.write_model(mdl)

  def generate_topology(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.generate_topology(mdl, aln, io)

  def patch(self):
    mdl = self.get_mdl()
    _modeller.patch(mdl)

  def patch_ss_templates(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.patch_ss_templates(mdl, aln, io)

  def patch_ss_model(self):
    mdl = self.get_mdl()
    _modeller.patch_ss_model(mdl)

  def mutate_model(self):
    mdl = self.get_mdl()
    _modeller.mutate_model(mdl)

  def build_model(self):
    mdl = self.get_mdl()
    _modeller.build_model(mdl)

  def unbuild_model(self):
    mdl = self.get_mdl()
    _modeller.unbuild_model(mdl)

  def transfer_xyz(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.transfer_xyz(mdl, aln, io)

  def transfer_res_numb(self):
    mdl = self.get_mdl()
    mdl2 = self.get_mdl(2)
    aln = self.get_aln()
    _modeller.transfer_res_numb(mdl, mdl2, aln)

  def rename_segments(self):
    mdl = self.get_mdl()
    _modeller.rename_segments(mdl)

  def pick_atoms(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    _modeller.pick_atoms(mdl, aln)

  def pick_hot_atoms(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    _modeller.pick_hot_atoms(mdl, edat)

  def randomize_xyz(self):
    mdl = self.get_mdl()
    _modeller.randomize_xyz(mdl)

  def iupac_model(self):
    mdl = self.get_mdl()
    _modeller.iupac_model(mdl)

  def reorder_atoms(self):
    mdl = self.get_mdl()
    _modeller.reorder_atoms(mdl)

  def rotate_dihedrals(self):
    mdl = self.get_mdl()
    _modeller.rotate_dihedrals(mdl)

  def orient_model(self):
    mdl = self.get_mdl()
    _modeller.orient_model(mdl)

  def rotate_model(self):
    mdl = self.get_mdl()
    _modeller.rotate_model(mdl)

  def write_data(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    _modeller.write_data(mdl, edat)

  def write_pdb_xref(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    _modeller.write_pdb_xref(mdl, aln)

  def make_region(self):
    mdl = self.get_mdl()
    _modeller.make_region(mdl)

  def color_aln_model(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    _modeller.color_aln_model(mdl, aln)

  def superpose(self):
    mdl = self.get_mdl()
    mdl2 = self.get_mdl(2)
    aln = self.get_aln()
    _modeller.superpose(mdl, mdl2, aln)

  def make_chains(self):
    mdl = self.get_mdl()
    _modeller.make_chains(mdl)

  def read_profile(self):
    prf = self.get_prf()
    _modeller.read_profile(prf)

  def write_profile(self):
    prf = self.get_prf()
    _modeller.write_profile(prf)

  def prof_to_aln(self):
    prf = self.get_prf()
    aln = self.get_aln()
    _modeller.prof_to_aln(prf, aln)

  def profile_profile_scan(self):
    prf = self.get_prf()
    _modeller.profile_profile_scan(prf)

  def build_profile(self):
    prf = self.get_prf()
    sdb = self.get_sdb()
    _modeller.build_profile(prf, sdb)

  def make_restraints(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.make_restraints(mdl, edat, aln, io)

  def define_symmetry(self):
    mdl = self.get_mdl()
    _modeller.define_symmetry(mdl)

  def pick_restraints(self):
    mdl = self.get_mdl()
    _modeller.pick_restraints(mdl)

  def condense_restraints(self):
    mdl = self.get_mdl()
    _modeller.condense_restraints(mdl)

  def add_restraint(self):
    mdl = self.get_mdl()
    _modeller.add_restraint(mdl)

  def delete_restraint(self):
    mdl = self.get_mdl()
    _modeller.delete_restraint(mdl)

  def reindex_restraints(self):
    mdl = self.get_mdl()
    mdl2 = self.get_mdl(2)
    _modeller.reindex_restraints(mdl, mdl2)

  def spline_restraints(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    _modeller.spline_restraints(mdl, edat)

  def read_restraints(self):
    mdl = self.get_mdl()
    _modeller.read_restraints(mdl)

  def write_restraints(self):
    mdl = self.get_mdl()
    _modeller.write_restraints(mdl)

  def read_sequence_db(self):
    sdb = self.get_sdb()
    _modeller.read_sequence_db(sdb)

  def write_sequence_db(self):
    sdb = self.get_sdb()
    _modeller.write_sequence_db(sdb)

  def sequence_search(self):
    sdb = self.get_sdb()
    aln = self.get_aln()
    io = self.get_io().modpt
    _modeller.sequence_search(sdb, aln, io)

  def seqfilter(self):
    sdb = self.get_sdb()
    _modeller.seqfilter(sdb)

  def read_parameters(self):
    gprsr = self.get_gprsr()
    _modeller.read_parameters(gprsr)

  def read_topology(self):
    tpl = self.get_tpl()
    _modeller.read_topology(tpl)

  def make_topology_model(self):
    tpl = self.get_tpl()
    _modeller.make_topology_model(tpl)

  def write_topology_model(self):
    tpl = self.get_tpl()
    _modeller.write_topology_model(tpl)

