import _modeller
from _modeller import wrtlog
from util.topcmds import topcmds
import util.modutil as modutil
import modfile

class TOPfile:
  def __init__(self, topfile):
    self.topcmds = top_commands()
    self.variables = variables(self.topcmds)
    self.topcmds.vars = self.variables
    # Read top.ini
    self.read_top_ini(self.variables)
    # Read libraries
    _modeller.libraries_read_libs(self.topcmds.get_libs(),
                                  self.variables['restyp_lib_file'],
                                  self.variables['rand_seed'])
    # Read default atom classes file
    _modeller.read_atom_classes(self.topcmds.get_gprsr(),
                                self.variables['atom_classes_file'])
    if type(topfile) is file:
      self.lines = self.read_top(topfile)
    else:
      fh = open(topfile, 'r')
      self.lines = self.read_top(fh)
      fh.close()

  def read_top_ini(self, vars):
    vars.topini = {}
    fh = open(_modeller.get_inifil(), 'r')
    while True:
      line = fh.readline()
      if line.startswith('--- KEYWORDS:'):
        self.read_topvars(fh, vars)
      elif line == '':
        break
    fh.close()

  def read_topvars(self, fh, vars):
    while True:
      line = fh.readline()
      if line == '' or line.startswith('--- END OF FILE'):
        break
      line = self.remove_comment(line.strip())
      if len(line) > 0:
        try:
          self.parse_top_ini_line(line.split(None, 4), vars)
        except TypeError, detail:
          wrtlog("read_top__E> " + str(detail))
          wrtlog("             top.ini line: " + line)
          raise

  def parse_top_ini_line(self, words, vars):
    typ = words[1][0]
    varname = words[2].lower()
    dim = int(words[3])
    vars.topini[varname] = (typ, dim)
    if len(words) > 4:
      vars[varname] = self.parse_var(words[4])

  def read_top(self, fh):
    lines = []
    lastline = ''
    while True:
      line = fh.readline()
      if line == '': break
      line = line.expandtabs(1)
      line = self.remove_comment(line.strip())
      if len(line) > 0:
        if lastline.endswith(';'):
          lines[-1] = lastline[:-1] + line
        else:
          lines.append(line)
        lastline = lines[-1]
    lines = self.process_includes(lines)
    return lines

  def run(self):
    self.runlines(self.lines)

  def process_includes(self, lines):
    newlines = []
    for line in lines:
      (cmd, vars) = self.break_line(line)
      if cmd == 'INCLUDE':
        self.set_top_vars(vars)
        try:
          fh = self.open_include_file(self.variables['include_file'])
        except IOError, detail:
          wrtlog("runlines__E> " + str(detail))
          wrtlog("             TOP Command line: " + line)
          raise
        newlines.extend(self.read_top(fh))
        fh.close()
      else:
        newlines.append(line)
    return newlines

  def open_include_file(self, fname):
    bindir = _modeller.get_bindir()
    dirs = [ '.', bindir ]
    exts = [ '', '.top' ]
    for dir in dirs:
      for ext in exts:
        inc = dir + '/' + fname + ext
        try:
          fh = open(inc, "r")
          return fh
        except IOError:
          pass
    raise IOError, "Could not find include file: %s" % (fname)

  def runlines(self, lines):
    subrout = self.process_subroutines(lines)
    callstack = []
    linenum = 0
    indxca = 0
    while indxca < len(lines):
      linenum = linenum + 1
      line = lines[indxca]
      loglevel = self.variables['output_control'][1]
      (cmd, vars) = self.break_line(line)
      try:
        if loglevel > 0 and cmd != 'SUBROUTINE':
          self.write_act(line, linenum, indxca + 1)
        if cmd == 'DO':
          indxca = self.handle_do(vars, indxca, lines, True)
        else:
          self.set_top_vars(vars)
          _modeller.top_pre()
          indxca = self.run_top_cmd(cmd, indxca, lines, callstack, subrout)
          _modeller.top_post()
      except (IndexError, SyntaxError, TypeError), detail:
        wrtlog("runlines__E> " + str(detail))
        wrtlog("             TOP Command line: " + line)
        raise

  def write_act(self, line, linenum, indxca):
    lenwrap = 57
    line = line.strip()
    splstr = line.split('=')
    for i in range(len(splstr) - 1):
      if not splstr[i].endswith(' '):
        splstr[i] = splstr[i] + ' '
    line = '='.join(splstr)
    thisline = line[:lenwrap]
    line = line[lenwrap:]
    if len(line) > 0:
      thisline = thisline + ';'
    else:
      thisline = thisline + ' '
    wrtlog('TOP_________>%6d%5d %s' % (linenum, indxca, thisline))
    while len(line) > 0:
      thisline = line[:lenwrap]
      line = line[lenwrap:]
      if len(line) > 0:
        thisline = thisline + ';'
      else:
        thisline = thisline + ' '
      wrtlog('                      ' + thisline)
    wrtlog('')

  def handle_do(self, var, indxca, lines, firsttime):
    ind = var.find('=')
    varname = var[:ind].strip().lower()
    varval = var[ind+1:].strip()
    varval = self.parse_var(varval)
    if type(varval) is not list:
      varval = [varval]

    if len(varval) == 2:
      varval.append(1)
    if len(varval) != 3:
      raise SyntaxError, "Wrong number of arguments to DO command"
    else:
      for var in varval:
        if type(var) is not int and type(var) is not float:
          raise SyntaxError, "DO commands require INTEGER or REAL arguments"
      if firsttime:
        self.variables[varname] = varval[0]
      else:
        self.variables[varname] = self.variables[varname] + varval[2]
    if self.variables[varname] > varval[1]:
      return self.skip_to('END_DO', indxca, lines, incs=['DO'],
                          decs=['END_DO']) + 1
    else:
      return indxca + 1

  def process_subroutines(self, lines):
    subrout = {}
    for num, line in enumerate(lines):
      (cmd, vars) = self.break_line(line)
      if cmd == 'SUBROUTINE':
        self.set_top_vars(vars)
        rname = self.variables['routine']
        if rname in subrout:
          wrtlog("Warning: subroutine %s redefined" % (rname))
        subrout[rname] = num
    return subrout

  def split_quoted(self, line, splch):
    start = 0
    end = 0
    numquote = 0
    last = ''
    splist = []
    for ch in line:
      if ch == "'" and last != '\\':
        numquote = numquote + 1
      if ch == splch and numquote % 2 == 0:
        splist.append(line[start:end])
        start = end + 1
      last = ch
      end = end + 1
    if end > start:
      splist.append(line[start:end])
    return splist

  def break_line(self, line):
    ind = line.find(' ')
    if ind >= 0:
      cmd = line[:ind].upper()
      vars = line[ind+1:].strip()
      if len(vars) > 0:
        if cmd == 'DO':
          vars = vars.replace(',', ' ')
        else:
          vars = self.split_quoted(vars, ',')
    else:
      cmd = line.upper()
      vars = ''
    return (cmd, vars)

  def remove_comment(self, line):
    ind = line.find('#')
    if ind >= 0:
      return line[:ind]
    else:
      return line

  def set_top_vars(self, vars):
    for var in vars:
      if len(var) == 0: continue
      ind = var.find('=')
      if ind < 0:
        ind = var.find(' ')
      if ind < 0:
        raise IndexError, "No '=' found in variable assignment"
      varname = var[:ind].strip().lower()
      varval = var[ind+1:].strip()
      varval = self.parse_var(varval, varname!='result')
      if varname in self.variables:
        self.variables[varname] = varval
      else:
        raise IndexError, "Variable name not recognized: %s" % varname.upper()

  def parse_var(self, cmdlin, subvar=True):
    vars = []
    curvar = ''
    delim = ''
    last = ''
    for ch in cmdlin:
      if ch == "'" and last != '\\':
        if delim == "'":
          vars.append(curvar)
          curvar = ''
          delim = ''
        else:
          delim = "'"
          if len(curvar) > 0:
            vars.append(self.get_top_rep(curvar))
            curvar = ''
      elif ch == ' ' and delim != "'":
        if len(curvar) > 0:
          vars.append(self.get_top_rep(curvar))
          curvar = ''
      else:
        if ch == "'" and last == '\\':
          curvar = curvar[:-1] + ch
        else:
          curvar = curvar + ch
      last = ch
    if delim == "'": raise SyntaxError, "Unmatched quote"
    if len(curvar) > 0: vars.append(self.get_top_rep(curvar))
    if subvar:
      newvars = []
      for var in vars:
        if type(var) is str and var.upper() == var:
          varlow = var.lower()
          try:
            getvar = self.variables[var.lower()]
            if type(getvar) is list or type(getvar) is tuple:
              newvars.extend(getvar)
            else:
              newvars.append(getvar)
          except IndexError:
            newvars.append(var)
        else:
          newvars.append(var)
      vars = newvars
    if len(vars) == 1:
      vars = vars[0]
    return vars

  def get_top_rep(self, curvar):
    try:
      return int(curvar)
    except ValueError:
      try:
        retval = float(curvar)
        if int(retval) == retval:
          return int(retval)
        else:
          return retval
      except ValueError:
        return curvar

  def sync_alignment(self, num, topname, getfunc):
    aln = self.topcmds.get_aln(num)
    len_aln = _modeller.get_alignment_nseq(aln)
    value = []
    for i in range(len_aln):
      value.append(getfunc(aln, i))
    self.variables[topname] = value

  def run_top_cmd(self, cmd, indxca, lines, callstack, subrout):
    excludes = [ 'SET', 'INCLUDE', 'DEFINE_STRING', 'DEFINE_INTEGER',
                 'DEFINE_REAL', 'DEFINE_LOGICAL', 'SUBROUTINE', 'CALL',
                 'END_SUBROUTINE', 'RETURN', 'OPERATE', 'STRING_OPERATE',
                 'IF', 'END_IF', 'STRING_IF', 'ELSE', 'DO', 'END_DO',
                 'EXIT', 'CYCLE', 'WRITE_TOP', 'RESET' ]
    if cmd not in excludes:
      lowcmd = cmd.lower()
      try:
        if lowcmd in dir(self.topcmds):
          eval('self.topcmds.' + lowcmd + '()')
        elif lowcmd in dir(_modeller):
          eval('_modeller.' + lowcmd + '()')
        elif "top_" + lowcmd in dir(_modeller):
          eval('_modeller.top_' + lowcmd + '()')
        else:
          raise SyntaxError, "Invalid TOP command: " + cmd
      except (_modeller.error, ZeroDivisionError, IOError, MemoryError,
              EOFError):
        self.variables['error_status'] = 1
        _modeller.top_error(1, self.variables['stop_on_error'])
      if lowcmd in ('read_alignment', 'expand_alignment', 'sequence_search',
                    'delete_alignment'):
        self.sync_alignment(1, 'align_codes', _modeller.get_alignment_codes)
        self.sync_alignment(1, 'atom_files', _modeller.get_alignment_atom_files)
      elif lowcmd == 'read_alignment2':
        self.sync_alignment(2, 'align_codes2', _modeller.get_alignment_codes)
        self.sync_alignment(2, 'atom_files2',
                            _modeller.get_alignment_atom_files)
    elif cmd == 'WRITE_TOP':
      self.write_top(self.variables['file'], lines)
    elif cmd == 'RESET':
      self.reset()
    elif cmd == 'DEFINE_STRING':
      self.make_top_variable('')
    elif cmd == 'DEFINE_REAL':
      self.make_top_variable(0.0)
    elif cmd == 'DEFINE_INTEGER':
      self.make_top_variable(0)
    elif cmd == 'DEFINE_LOGICAL':
      self.make_top_variable(False)
    elif cmd == 'SUBROUTINE':
      return self.skip_to('END_SUBROUTINE', indxca, lines) + 1
    elif cmd == 'CYCLE':
      return self.skip_to('END_DO', indxca, lines, incs=['DO'],
                          decs=['END_DO'])
    elif cmd == 'EXIT':
      return self.skip_to('END_DO', indxca, lines, incs=['DO'],
                          decs=['END_DO']) + 1
    elif cmd == 'END_DO':
      indxca = self.skip_to('DO', indxca, lines, incs=['END_DO'],
                            decs=['DO'], indinc=-1)
      line = lines[indxca]
      (cmd, vars) = self.break_line(line)
      return self.handle_do(vars, indxca, lines, False)
    elif cmd == 'IF' or cmd == 'STRING_IF':
      # Make sure there is a terminating END_IF
      self.skip_to('END_IF', indxca, lines, incs=['IF', 'STRING_IF'],
                   decs=['END_IF'])
      if cmd == 'IF':
        res = self.numeric_if(self.variables['operation'],
                              self.variables['arguments'])
      else:
        res = self.string_if(self.variables['operation'],
                             self.variables['string_arguments'])
      if not res:
        return self.skip_to(['ELSE', 'END_IF'], indxca, lines,
                            incs=['IF', 'STRING_IF'], decs=['END_IF']) + 1
    elif cmd == 'ELSE':
      return self.skip_to('END_IF', indxca, lines,
                          incs=['IF', 'STRING_IF'], decs=['END_IF']) + 1
    elif cmd == 'CALL':
      callstack.append(indxca)
      return self.jump_to_subroutine(self.variables['routine'], subrout) + 1
    elif cmd == 'END_SUBROUTINE' or cmd == 'RETURN':
      if len(callstack) > 0:
        return callstack.pop() + 1
      else:
        raise SyntaxError, cmd + " but not within a SUBROUTINE"
    elif cmd == 'STRING_OPERATE':
      res = self.string_operate(self.variables['operation'],
                                self.variables['string_arguments'])
      name = self.variables['result'].lower()
      if name in self.variables:
        self.variables[name] = res
      else:
        raise IndexError, "Bad variable name for RESULT: %s" % (name.upper())
    elif cmd == 'OPERATE':
      res = self.operate(self.variables['operation'],
                         self.variables['arguments'])
      name = self.variables['result'].lower()
      if name in self.variables:
        self.variables[name] = res
      else:
        raise IndexError, "Bad variable name for RESULT: %s" % (name.upper())
    return indxca + 1

  def write_top(self, filename, lines):
    fh = open(filename, "w")
    for line in lines:
      fh.write(line + '\n')
    fh.close()

  def reset(self):
    self.variables = variables(self.topcmds)
    self.topcmds.vars = self.variables
    # Read top.ini
    self.read_top_ini(self.variables)

  def string_if(self, operation, arguments):
    operation = operation.upper()
    if operation == 'EQ':
      return arguments[0] == arguments[1]
    elif operation == 'NE':
      return arguments[0] != arguments[1]
    elif operation == 'INDEX':
      return arguments[0].find(arguments[1]) >= 0
    else:
      raise SyntaxError, "Invalid OPERATION for STRING_IF: %s" % (operation)

  def numeric_if(self, operation, orig_arguments):
    operation = operation.upper()
    arguments = []
    for arg in orig_arguments:
      try:
        arguments.append(float(arg))
      except ValueError:
        raise SyntaxError, ("Argument for numeric IF must be REAL or INTEGER: "
                            + str(arg))
    if operation == 'EQ':
      return abs(arguments[0] - arguments[1]) < 1e-10
    elif operation == 'GT':
      return arguments[0] > arguments[1]
    elif operation == 'LT':
      return arguments[0] < arguments[1]
    elif operation == 'GE':
      return arguments[0] >= arguments[1] - 1e-10
    elif operation == 'LE':
      return arguments[0] <= arguments[1] + 1e-10
    elif operation == 'NE':
      return abs(arguments[0] - arguments[1]) > 1e-10
    else:
      raise SyntaxError, "Invalid OPERATION for IF: %s" % (operation)
      
  def string_operate(self, operation, arguments):
    if operation.upper() == 'CONCATENATE':
      val = ''
      for arg in arguments: val = val + arg
#     The old Fortran code did this, since strings can't end in whitespace
      return val.replace('@', ' ')
    else:
      raise SyntaxError, "Invalid OPERATION for STRING_OPERATE: " + operation

  def operate(self, operation, arguments):
    operation = operation.upper()
    if operation == 'SUM':
      return sum(arguments)
    elif operation == 'MULTIPLY':
      val = 0
      for arg in arguments: val = val * arg
      return val
    elif operation == 'DIVIDE':
      return arguments[0] / arguments[1]
    elif operation == 'POWER':
      return arguments[0] ** arguments[1]
    elif operation == 'MOD':
      return arguments[0] % arguments[1]
    else:
      raise SyntaxError, "Invalid OPERATION for OPERATE: %s" % (operation)

  def skip_to(self, gotocmds, indxca, lines, incs=[], decs=[], indinc = 1):
    if type(gotocmds) is not list: gotocmds = [gotocmds]
    inclevel = 0
    indxca = indxca + indinc
    while indxca < len(lines) and indxca >= 0:
      (cmd, vars) = self.break_line(lines[indxca])
      if cmd in gotocmds and inclevel == 0:
        return indxca
      elif cmd in incs:
        inclevel = inclevel + 1
      elif cmd in decs:
        inclevel = inclevel - 1
        if inclevel < 0:
          raise SyntaxError, "Mismatched " + str(incs) + " and " + str(decs)
      indxca = indxca + indinc
    raise SyntaxError, "Cannot find matching " + str(gotocmds)

  def jump_to_subroutine(self, rname, subrout):
    if rname in subrout:
      line = subrout[rname]
      return line
    else:
      raise SyntaxError, "No such subroutine: " + rname

  def make_top_variable(self, initval):
    vars = self.variables['variables']
    if type(vars) is not list:
      vars = [ vars ]
    for var in vars:
      var = var.lower()
      self.variables[var] = initval

class variables:
  deftops = { 'include_file':'__mod', 'variables':[''], 'arguments':[''],
              'string_arguments':[''], 'operation':'', 'result':'',
              'routine':'', 'numb_of_sequences':None,
              'numb_of_sequences2':None, 'n_schedule':None, 'schedule_step':0,
              'topology_model':3, 'rand_seed':-8123, 'seq_id':-999.0,
              'output_control':[1, 0, 1, 1, 0] }
  ourvars = {}
  aln_nseq = [ 0, 0 ]
  edat_members = { 'lennard_jones_switch':[0], 'coulomb_switch':[0],
                   'contact_shell':0.0, 'relative_dielectric':0.0,
                   'radii_factor':0.0, 'update_dynamic':0.0,
                   'nonbonded_sel_atoms':0, 'covalent_cys':False,
                   'excl_local':[False], 'nlogn_use':0, 'sphere_stdv':0.0,
                   'dynamic_pairs':False, 'dynamic_sphere':False,
                   'dynamic_coulomb':False, 'dynamic_lennard':False,
                   'dynamic_modeller':False, 'dynamic_access':False,
                   'dynamic_gbsa':False }
  io_members = { 'hydrogen_io':False, 'hetatm_io':False, 'water_io':False,
                 'atom_files_directory':'' }

  def __init__(self, topcmds):
    self.topcmds = topcmds
    self.topvars = {}
    for var in self.deftops.keys():
      self.ourvars[var] = self.deftops[var]
    for var in self.edat_members.keys():
      self.ourvars[var] = self.edat_members[var]
    for var in self.io_members.keys():
      self.ourvars[var] = self.io_members[var]

  def __setitem__(self, key, value):
    if key in self.topini and key not in self.deftops \
             and key not in self.edat_members and key not in self.io_members:
      (typ, num) = self.topini[key]
      if typ == 'L':
        value = self.parse_bool(value)
      if num != 1 and type(value) is not list and type(value) is not tuple:
        value = [ value ]
      modutil.set_topvars({key:value}, self.topvars, self.topini)
      if key == 'align_codes':
        self.to_alignment(1, value, _modeller.set_alignment_codes)
      elif key == 'align_codes2':
        self.to_alignment(2, value, _modeller.set_alignment_codes)
      elif key == 'atom_files':
        self.to_alignment(1, value, _modeller.set_alignment_atom_files)
      elif key == 'atom_files2':
        self.to_alignment(2, value, _modeller.set_alignment_atom_files)
    else:
      if key in self.ourvars and self.ourvars[key] == None:
        raise SyntaxError, key.upper() + " is a read-only variable"
      if key in self.ourvars and (type(self.ourvars[key]) is bool or
         (type(self.ourvars[key]) is list and
          type(self.ourvars[key][0]) is bool)):
        value = self.parse_bool(value)
      if key in self.edat_members:
        edat = self.topcmds.get_edat()
        exec("edat." + key + " = value")
      elif key in self.io_members:
        io = self.topcmds.get_io()
        if key[-3:] == '_io':
          key = key[:-3]
        exec("io." + key + " = value")
      elif key == 'schedule_step':
        self.set_sched_step(value)
      elif key == 'topology_model':
        self.set_topmod(value)
      elif key == 'rand_seed':
        self.set_rand_seed(value)
      elif key == 'seq_id':
        self.set_seq_id(value)
      elif key == 'output_control':
        self.set_output_control(value)
      else:
        if type(value) is str:
          value = modutil.str_macro(value, self.topvars)
        self.ourvars[key] = value

  def __getitem__(self, key):
    if key in self.ourvars:
      if key in self.edat_members:
        edat = self.topcmds.get_edat()
        return eval("edat." + key)
      elif key in self.io_members:
        io = self.topcmds.get_io()
        if key[-3:] == '_io':
          key = key[:-3]
        return eval("io." + key)
      elif key == 'numb_of_sequences':
        return self.get_aln_nseq(1)
      elif key == 'numb_of_sequences2':
        return self.get_aln_nseq(2)
      elif key == 'n_schedule':
        return self.get_n_schedule()
      elif key == 'schedule_step':
        return self.get_sched_step()
      elif key == 'topology_model':
        return self.get_topmod()
      elif key == 'rand_seed':
        return self.get_rand_seed()
      elif key == 'seq_id':
        return self.get_seq_id()
      elif key == 'output_control':
        return self.get_output_control()
      else:
        return self.ourvars[key]
    elif key in self.topini:
      value = modutil.get_topvars(key, self.topvars)
      return value
    else:
      raise IndexError

  def __contains__(self, item):
    return (item in self.ourvars or item in self.topini)

  def get_aln_nseq(self, num):
    aln = self.topcmds.get_aln(num)
    return _modeller.get_alignment_nseq(aln)
 
  def get_sched(self):
    mdl = self.topcmds.get_mdl(1)
    return _modeller.get_model_schedule(mdl)

  def get_topmod(self):
    tpl = self.topcmds.get_tpl()
    return _modeller.get_topology_submodel(tpl)

  def set_topmod(self, val):
    tpl = self.topcmds.get_tpl()
    _modeller.set_topology_submodel(tpl, val)

  def get_rand_seed(self):
    libs = self.topcmds.get_libs()
    return _modeller.get_libraries_rand_seed(libs)

  def set_rand_seed(self, val):
    libs = self.topcmds.get_libs()
    _modeller.set_libraries_rand_seed(libs, val)

  def get_seq_id(self):
    mdl = self.topcmds.get_mdl(1)
    return _modeller.get_model_seq_id(mdl)

  def set_seq_id(self, val):
    mdl = self.topcmds.get_mdl(1)
    _modeller.set_model_seq_id(mdl, val)

  def get_output_control(self):
    vals = []
    for indx in range(1,6):
      vals.append(_modeller.get_log(indx))
    return vals

  def set_output_control(self, vals):
    for (indx, val) in enumerate(vals):
      _modeller.set_log(indx+1, val)

  def get_n_schedule(self):
    return _modeller.get_schedule_nsch(self.get_sched())

  def get_sched_step(self):
    return _modeller.get_schedule_step(self.get_sched())

  def set_sched_step(self, val):
    return _modeller.set_schedule_step(self.get_sched(), val)

  def to_alignment(self, num, value, setfunc):
    aln = self.topcmds.get_aln(num)
    len_aln = _modeller.get_alignment_nseq(aln)
    self.aln_nseq[num - 1] = len_aln
    numal = min(len(value), len_aln)
    for num in range(numal):
      setfunc(aln, num, value[num])

  def parse_bool(self, varval):
    notlist = False
    if type(varval) is not list:
      varval = [ varval ]
      notlist = True
    newvarval = []
    for var in varval:
      if type(var) is str:
        var = var.lower()
        if var == 'on':
          newvarval.append(True)
        elif var == 'off':
          newvarval.append(False)
        else:
          newvarval.append(var)
      else:
        newvarval.append(var)
    if notlist:
      return newvarval[0]
    else:
      return newvarval


class top_commands(topcmds):
    def default_file(self, varname, deffile_id, exts=None):
        file = self.vars[varname]
        if file.upper().find('DEFAULT') >= 0:
            root_name = self.vars['root_name']
            file_id = self.vars['file_id']
            id1 = self.vars['id1']
            id2 = self.vars['id2']
            file_ext = self.vars['file_ext']
            if file_id.upper().find('DEFAULT') >= 0:
                file_id = deffile_id
            file = modfile.default(root_name, file_id, id1, id2, file_ext)
            self.vars[varname] = file
        if exts is not None:
            directory = self.vars['directory']
            file = _modeller.fullfn(directory, file, exts)
            self.vars[varname] = file

    def write_model(self):
        self.default_file('file', '.B')
        topcmds.write_model(self)
    def write_model2(self):
        self.default_file('file', '.B')
        topcmds.write_model2(self)
    def read_restraints(self):
        self.default_file('file', '.C', ':.rsr')
        topcmds.read_restraints(self)
    def write_restraints(self):
        self.default_file('file', '.C')
        topcmds.write_restraints(self)
    def read_model(self):
        self.default_file('file', 'B')
        topcmds.read_model(self)
    def read_model2(self):
        self.default_file('file', '.B')
        topcmds.read_model2(self)
    def switch_trace(self):
        self.default_file('file', '.D')
        topcmds.switch_trace(self)
    def read_schedule(self):
        self.default_file('file', 'S', ':.sch')
        topcmds.read_schedule(self)
    def write_schedule(self):
        self.default_file('file', '.S')
        topcmds.write_schedule(self)
    def id_table(self):
        self.default_file('matrix_file', '.M')
        topcmds.id_table(self)
    def write_topology_model(self):
        self.default_file('file', '.toplib')
        topcmds.write_topology_model(self)
    def write_alignment(self):
        self.default_file('file', '.A')
        topcmds.write_alignment(self)
    def sequence_comparison(self):
        self.default_file('rr_file', '.A', ':.mat')
        self.default_file('matrix_file', '.M')
        self.default_file('variability_file', '.V')
        topcmds.sequence_comparison(self)
    def read_topology(self):
        self.default_file('file', '.T', ':.lib')
        topcmds.read_topology(self)
    def energy(self):
        self.default_file('file', 'P')
        topcmds.energy(self)
    def align(self):
        self.default_file('rr_file', '.A', ':.mat')
        topcmds.align(self)
    def sequence_search(self):
        self.default_file('rr_file', '.mat', ':.mat')
        topcmds.sequence_search(self)
    def malign(self):
        self.default_file('rr_file', '.A', ':.mat')
        topcmds.malign(self)
    def principal_components(self):
        self.default_file('matrix_file', '.G')
        self.default_file('file', '.dat')
        topcmds.principal_components(self)
    def align2d(self):
        self.default_file('rr_file', '.A', ':.mat')
        topcmds.align2d(self)
    def write_pdb_xref(self):
        self.default_file('file', '.X')
        topcmds.write_pdb_xref(self)
    def build_profile(self):
        self.default_file('rr_file', '.mat', ':.mat')
        topcmds.build_profile(self)
    def read_sequence_db(self):
        chains = modutil.get_topvars('chains_list', self.vars)
        if chains.upper() != 'ALL':
            self.default_file('chains_list', 'H', ':.list')
        self.default_file('seq_database_file', 'H', ':.seq')
        topcmds.read_sequence_db(self)
    def write_sequence_db(self):
        self.default_file('chains_list', 'H')
        self.default_file('seq_database_file', 'H')
        topcmds.write_sequence_db(self)
    def seqfilter(self):
        self.default_file('rr_file', '.mat', ':.mat')
        topcmds.seqfilter(self)
    def open(self):
        self.default_file('objects_file', 'TOP')
        topcmds.open(self)
    def inquire(self):
        self.default_file('file', '.B')
        topcmds.inquire(self)
    def read_alignment(self):
        self.default_file('file', '.A', ':.ali')
        topcmds.read_alignment(self)
    def read_alignment2(self):
        self.default_file('file', '.A', ':.ali')
        topcmds.read_alignment2(self)
    def read_parameters(self):
        self.default_file('file', '.toplib', ':.lib')
        topcmds.read_parameters(self)
