def cispeptide(rsr, atom_ids1, atom_ids2):
    """To create cis-peptide bond stereochemical restraints

       Note   : you must have done the STEREOCHEMICAL restraints already.

       Example (cis-peptide between residues 4 and 5):

       cispeptide(rsr, atom_ids1=('O:4', 'C:4', 'N:5', 'CA:5'),
                       atom_ids2=('CA:4', 'C:4', 'N:5', 'CA:5'))
    """

    rsr.unpick(atom_ids = atom_ids1)
    rsr.add(restraint_parameters=(3, 1, 3, 3, 4, 2, 0, 3.141593, 0.087))

    rsr.unpick(atom_ids = atom_ids2)
    rsr.add(restraint_parameters=(3, 1, 3, 3, 4, 2, 0, 0.0, 0.087))
