import _modeller
import util.top as top

class topology(object):
    """All information from a residue topology file"""

    def __init__(self, libs):
        self.libs = libs
        self.env = self.libs.env
        self.__modpt = _modeller.get_libraries_topology(libs.modpt)
        self.top = top.top(self.env)

    def __get_modpt(self):
        return self.__modpt

    def clear(self):
        _modeller.clear_topology(self.modpt, self.env.libs.modpt)

    def read(self, file, libs=None, **vars):
        """Reads a residue topology file"""
        self.clear()
        return self.append(file, libs, **vars)

    def append(self, file, libs=None, **vars):
        """Appends a residue topology file"""
        if libs is None:
            libs = self.env.libs
        return self.top.read_topology('topology.append', tpl=self.modpt, 
                                      file=file, libs=libs.modpt,
                                      add_topology=True, **vars)

    def make(self, submodel, libs=None):
        """Reduces the most detailed topology to a sub-topology model"""
        if libs is None:
            libs = self.env.libs
        self.submodel = submodel
        return self.top.make_topology_model('topology.make', tpl=self.modpt,
                                            libs=libs.modpt)

    def write(self, libs=None, **vars):
        """Writes topology library to a file"""
        if libs is None:
            libs = self.env.libs
        return self.top.write_topology_model('topology.write', tpl=self.modpt,
                                             libs=libs.modpt, **vars)

    def __get_submodel(self):
        return _modeller.get_topology_submodel(self.modpt)
    def __set_submodel(self, val):
        _modeller.set_topology_submodel(self.modpt, val)
    def __get_in_memory(self):
        return _modeller.topology_read(self.modpt)

    modpt = property(__get_modpt)
    submodel = property(__get_submodel, __set_submodel)
    in_memory = property(__get_in_memory)
