import _modeller
import modutil

class top:
  def __init__(self, defs=None):
    self.defs = defs
  def set_tops(self, logname, vars, arg_allowed):
    return modutil.set_tops(logname, vars, self.defs, arg_allowed)
  def get_argument(self, key, vars):
    if key in vars:
      return vars[key]
    elif self.defs and key in dir(self.defs):
      return eval("self.defs."+key)

  def delete_alignment(self, logname, aln, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.delete_alignment(aln, *args)

  def read_alignment2(self, logname, aln2, io, libs, **vars):
    args = self.set_tops(logname, vars, ('align_codes2', 'atom_files2', 'file', 'remove_gaps', 'alignment_format', 'add_sequence', 'rewind_file', 'close_file'))
    return _modeller.read_alignment2(aln2, io, libs, *args)

  def read_model2(self, logname, mdl2, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'model_format', 'model2_segment'))
    return _modeller.read_model2(mdl2, aln, io, libs, *args)

  def write_model2(self, logname, mdl2, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory', 'model_format', 'no_ter'))
    return _modeller.write_model2(mdl2, libs, *args)

  def read_alignment(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('align_codes', 'atom_files', 'file', 'remove_gaps', 'alignment_format', 'add_sequence', 'rewind_file', 'close_file'))
    return _modeller.read_alignment(aln, io, libs, *args)

  def check_alignment(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.check_alignment(aln, io, libs, *args)

  def compare_alignments(self, logname, aln, aln2, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.compare_alignments(aln, aln2, *args)

  def sequence_to_ali(self, logname, aln, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('atom_files', 'align_codes', 'add_sequence'))
    return _modeller.sequence_to_ali(aln, mdl, libs, *args)

  def write_alignment(self, logname, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory', 'alignment_format', 'alignment_features', 'align_block', 'align_alignment'))
    return _modeller.write_alignment(aln, libs, *args)

  def edit_alignment(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('overhang', 'edit_align_codes', 'base_align_codes', 'min_base_entries'))
    return _modeller.edit_alignment(aln, io, libs, *args)

  def describe(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.describe(aln, io, libs, *args)

  def id_table(self, logname, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('matrix_file', 'output_directory'))
    return _modeller.id_table(aln, libs, *args)

  def sequence_comparison(self, logname, aln, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('rr_file', 'matrix_file', 'variability_file', 'output_directory', 'max_gaps_match'))
    return _modeller.sequence_comparison(aln, mdl, libs, *args)

  def align(self, logname, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('off_diagonal', 'max_gap_length', 'local_alignment', 'matrix_offset', 'gap_penalties_1d', 'read_weights', 'write_weights', 'n_subopt', 'subopt_offset', 'weigh_sequences', 'smooth_prof_weight', 'align_what', 'weights_type', 'input_weights_file', 'output_weights_file', 'rr_file', 'overhang', 'align_block'))
    return _modeller.align(aln, libs, *args)

  def align2d(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('overhang', 'align_block', 'rr_file', 'align_what', 'off_diagonal', 'max_gap_length', 'local_alignment', 'matrix_offset', 'gap_penalties_1d', 'gap_penalties_2d', 'surftyp', 'fit', 'fix_offsets', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file', 'n_subopt', 'subopt_offset', 'read_profile', 'input_profile_file', 'write_profile', 'output_profile_file', 'weigh_sequences', 'smooth_prof_weight', 'weights_type'))
    return _modeller.align2d(aln, io, libs, *args)

  def malign(self, logname, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('rr_file', 'off_diagonal', 'local_alignment', 'matrix_offset', 'overhang', 'align_block', 'gap_penalties_1d'))
    return _modeller.malign(aln, libs, *args)

  def align_consensus(self, logname, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('align_block', 'gap_penalties_1d', 'max_gap_length', 'read_weights', 'write_weights', 'weigh_sequences', 'input_weights_file', 'output_weights_file', 'weights_type', 'smooth_prof_weight'))
    return _modeller.align_consensus(aln, libs, *args)

  def compare(self, logname, aln, edat, io, libs, **vars):
    args = self.set_tops(logname, vars, ('compare_mode', 'fit', 'fit_atoms', 'matrix_file', 'output', 'asgl_output', 'refine_local', 'rms_cutoffs', 'distance_atoms'))
    return _modeller.compare(aln, edat, io, libs, *args)

  def align3d(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('off_diagonal', 'overhang', 'local_alignment', 'matrix_offset', 'gap_penalties_3d', 'fit', 'fit_atoms', 'align3d_trf', 'output', 'align3d_repeat'))
    return _modeller.align3d(aln, io, libs, *args)

  def malign3d(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('no_ter', 'off_diagonal', 'overhang', 'local_alignment', 'matrix_offset', 'gap_penalties_3d', 'fit', 'fit_atoms', 'output', 'write_whole_pdb', 'current_directory', 'write_fit', 'edit_file_ext'))
    return _modeller.malign3d(aln, io, libs, *args)

  def salign(self, logname, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('residue_type2', 'no_ter', 'overhang', 'off_diagonal', 'matrix_offset', 'gap_penalties_1d', 'gap_penalties_2d', 'gap_penalties_3d', 'feature_weights', 'rms_cutoffs', 'fit', 'surftyp', 'fit_on_first', 'gap_function', 'align_block', 'max_gap_length', 'align_what', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file', 'weigh_sequences', 'smooth_prof_weight', 'fix_offsets', 'substitution', 'comparison_type', 'matrix_comparison', 'alignment_type', 'edit_file_ext', 'weights_type', 'similarity_flag', 'bkgrnd_prblty_file', 'ext_tree', 'dendrogram_file', 'matrix_scaling_factor', 'auto_overhang', 'overhang_factor', 'overhang_auto_limit', 'local_alignment', 'improve_alignment', 'fit_atoms', 'output', 'write_whole_pdb', 'current_directory', 'write_fit', 'fit_pdbnam', 'rr_file', 'n_subopt', 'subopt_offset', 'align3d_trf', 'normalize_pp_scores', 'gap_gap_score', 'gap_residue_score'))
    return _modeller.salign(aln, io, libs, *args)

  def aln_to_prof(self, logname, aln, prf, **vars):
    args = self.set_tops(logname, vars, ('clean_sequences'))
    return _modeller.aln_to_prof(aln, prf, *args)

  def expand_alignment(self, logname, aln, **vars):
    args = self.set_tops(logname, vars, ('expand_control', 'root_name', 'file_id', 'file_ext'))
    return _modeller.expand_alignment(aln, *args)

  def segment_matching(self, logname, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('rr_file', 'file', 'align_block', 'min_loop_length', 'segment_shifts', 'segment_growth_n', 'segment_growth_c', 'segment_cutoff', 'segment_report', 'output_directory', 'root_name', 'file_id', 'file_ext'))
    return _modeller.segment_matching(aln, libs, *args)

  def read_density(self, logname, den, **vars):
    args = self.set_tops(logname, vars, ('file', 'em_density_format', 'em_map_size', 'filter_type', 'voxel_size', 'resolution', 'filter_values', 'density_type'))
    return _modeller.read_density(den, *args)

  def em_grid_search(self, logname, den, **vars):
    args = self.set_tops(logname, vars, ('em_density_format', 'num_structures', 'dock_order', 'start_type', 'translate_type', 'number_of_steps', 'angular_step_size', 'temperature', 'best_docked_models', 'em_fit_output_file', 'em_pdb_name', 'chains_num'))
    return _modeller.em_grid_search(den, *args)

  def make_schedule(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('library_schedule', 'residue_span_range', 'schedule_scale'))
    return _modeller.make_schedule(mdl, *args)

  def read_schedule(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('file', 'schedule_scale'))
    return _modeller.read_schedule(mdl, *args)

  def write_schedule(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory'))
    return _modeller.write_schedule(mdl, *args)

  def energy(self, logname, mdl, edat, libs, **vars):
    args = self.set_tops(logname, vars, ('deviation', 'asgl_output', 'normalize_profile', 'residue_span_range', 'output', 'file', 'output_directory', 'smoothing_window', 'viol_report_cut', 'viol_report_cut2', 'schedule_scale'))
    return _modeller.energy(mdl, edat, libs, *args)

  def optimize(self, logname, mdl, edat, libs, **vars):
    args = self.set_tops(logname, vars, ('optimization_method', 'init_velocities', 'temperature', 'md_time_step', 'min_atom_shift', 'cap_atom_shift', 'write_all_atoms', 'no_ter', 'trace_output', 'equilibrate', 'max_iterations', 'residue_span_range', 'md_return', 'output', 'id2', 'root_name', 'file_id', 'file_ext', 'output_directory'))
    return _modeller.optimize(mdl, edat, libs, *args)

  def switch_trace(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory'))
    return _modeller.switch_trace(mdl, *args)

  def debug_function(self, logname, mdl, edat, libs, **vars):
    args = self.set_tops(logname, vars, ('residue_span_range', 'debug_function_cutoff', 'detailed_debugging'))
    return _modeller.debug_function(mdl, edat, libs, *args)

  def assess_model(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('assess_method'))
    return _modeller.assess_model(mdl, libs, *args)

  def assess_ga341(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.assess_ga341(mdl, libs, *args)

  def dendrogram(self, logname, **vars):
    args = self.set_tops(logname, vars, ('matrix_file', 'cluster_cut'))
    return _modeller.dendrogram(*args)

  def principal_components(self, logname, **vars):
    args = self.set_tops(logname, vars, ('matrix_file', 'file'))
    return _modeller.principal_components(*args)

  def system(self, logname, **vars):
    args = self.set_tops(logname, vars, ('command'))
    return _modeller.top_system(*args)

  def delete_file(self, logname, **vars):
    args = self.set_tops(logname, vars, ('file'))
    return _modeller.delete_file(*args)

  def inquire(self, logname, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory'))
    return _modeller.inquire(*args)

  def read_atom_classes(self, logname, gprsr, **vars):
    args = self.set_tops(logname, vars, ('atom_classes_file'))
    return _modeller.read_atom_classes(gprsr, *args)

  def read_group_restraints(self, logname, gprsr, libs, **vars):
    args = self.set_tops(logname, vars, ('file'))
    return _modeller.read_group_restraints(gprsr, libs, *args)

  def time_mark(self, logname, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.time_mark(*args)

  def read_model(self, logname, mdl, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'model_format', 'model_segment'))
    return _modeller.read_model(mdl, aln, io, libs, *args)

  def write_model(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory', 'model_format', 'no_ter', 'write_all_atoms'))
    return _modeller.write_model(mdl, libs, *args)

  def generate_topology(self, logname, mdl, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('add_segment', 'sequence', 'patch_default'))
    return _modeller.generate_topology(mdl, aln, io, libs, *args)

  def patch(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('residue_type', 'residue_ids'))
    return _modeller.patch(mdl, libs, *args)

  def patch_ss_templates(self, logname, mdl, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.patch_ss_templates(mdl, aln, io, libs, *args)

  def patch_ss_model(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.patch_ss_model(mdl, libs, *args)

  def mutate_model(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('residue_type'))
    return _modeller.mutate_model(mdl, libs, *args)

  def build_model(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('build_method', 'initialize_xyz'))
    return _modeller.build_model(mdl, libs, *args)

  def unbuild_model(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.unbuild_model(mdl, *args)

  def transfer_xyz(self, logname, mdl, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('cluster_cut', 'cluster_method'))
    return _modeller.transfer_xyz(mdl, aln, io, libs, *args)

  def transfer_res_numb(self, logname, mdl, mdl2, aln, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.transfer_res_numb(mdl, mdl2, aln, libs, *args)

  def rename_segments(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('segment_ids', 'renumber_residues'))
    return _modeller.rename_segments(mdl, *args)

  def pick_atoms(self, logname, mdl, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('pick_atoms_set', 'sphere_radius', 'selection_slab', 'gap_extension', 'minmax_loop_length', 'res_types', 'atom_types', 'selection_mode', 'selection_search', 'selection_status', 'selection_from', 'sphere_center', 'selection_segment'))
    return _modeller.pick_atoms(mdl, aln, libs, *args)

  def pick_hot_atoms(self, logname, mdl, edat, libs, **vars):
    args = self.set_tops(logname, vars, ('extend_hot_spot', 'selection_mode', 'residue_span_range', 'pick_hot_cutoff', 'viol_report_cut'))
    return _modeller.pick_hot_atoms(mdl, edat, libs, *args)

  def randomize_xyz(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('deviation'))
    return _modeller.randomize_xyz(mdl, libs, *args)

  def iupac_model(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.iupac_model(mdl, libs, *args)

  def reorder_atoms(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.reorder_atoms(mdl, libs, *args)

  def rotate_dihedrals(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('deviation', 'change', 'dihedrals'))
    return _modeller.rotate_dihedrals(mdl, libs, *args)

  def orient_model(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.orient_model(mdl, *args)

  def rotate_model(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('translation', 'rotation_matrix', 'rotation_axis', 'rotation_angle'))
    return _modeller.rotate_model(mdl, *args)

  def write_data(self, logname, mdl, edat, libs, **vars):
    args = self.set_tops(logname, vars, ('surftyp', 'neighbor_cutoff', 'accessibility_type', 'output', 'file', 'probe_radius', 'psa_integration_step'))
    return _modeller.write_data(mdl, edat, libs, *args)

  def write_pdb_xref(self, logname, mdl, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory', 'model_segment'))
    return _modeller.write_pdb_xref(mdl, aln, libs, *args)

  def make_region(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('atom_accessibility', 'region_size'))
    return _modeller.make_region(mdl, libs, *args)

  def color_aln_model(self, logname, mdl, aln, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.color_aln_model(mdl, aln, *args)

  def superpose(self, logname, mdl, mdl2, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('swap_atoms_in_res', 'reference_atom', 'reference_distance', 'superpose_refine', 'fit', 'refine_local', 'rms_cutoffs'))
    return _modeller.superpose(mdl, mdl2, aln, libs, *args)

  def make_chains(self, logname, mdl, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'structure_types', 'minimal_resolution', 'minimal_chain_length', 'max_nonstdres', 'chop_nonstd_terminii', 'minimal_stdres', 'alignment_format'))
    return _modeller.make_chains(mdl, libs, *args)

  def read_profile(self, logname, prf, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'profile_format'))
    return _modeller.read_profile(prf, libs, *args)

  def write_profile(self, logname, prf, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'n_prof_iterations', 'gap_penalties_1d', 'matrix_offset', 'profile_format', 'rr_file'))
    return _modeller.write_profile(prf, libs, *args)

  def prof_to_aln(self, logname, prf, aln, libs, **vars):
    args = self.set_tops(logname, vars, ('append_aln'))
    return _modeller.prof_to_aln(prf, aln, libs, *args)

  def profile_profile_scan(self, logname, prf, libs, **vars):
    args = self.set_tops(logname, vars, ('profile_list_file', 'matrix_offset', 'profile_format', 'rr_file', 'gap_penalties_1d', 'matrix_scaling_factor', 'max_aln_evalue', 'aln_base_filename', 'score_statistics', 'output_alignments', 'output_scores', 'output_score_file', 'pssm_weights_type', 'write_summary', 'summary_file'))
    return _modeller.profile_profile_scan(prf, libs, *args)

  def build_profile(self, logname, prf, sdb, libs, **vars):
    args = self.set_tops(logname, vars, ('gap_penalties_1d', 'matrix_offset', 'rr_file', 'n_prof_iterations', 'max_aln_evalue', 'matrix_scaling_factor', 'check_profile', 'output_scores', 'output_score_file', 'gaps_in_target', 'score_statistics', 'pssm_weights_type', 'write_pssm', 'pssm_file'))
    return _modeller.build_profile(prf, sdb, libs, *args)

  def make_restraints(self, logname, mdl, edat, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('residue_span_range', 'residue_grouping', 'restraint_type', 'restraint_sel_atoms', 'restraint_group', 'basis_pdf_weight', 'distance_rsr_model', 'maximal_distance', 'basis_relative_weight', 'spline_on_site', 'residue_span_sign', 'intersegment', 'add_restraints', 'dih_lib_only', 'spline_dx', 'spline_min_points', 'spline_range', 'mnch_lib', 'accessibility_type', 'restraint_stdev', 'restraint_stdev2', 'sheet_h_bonds', 'surftyp', 'restraint_parameters', 'distance_atoms', 'atom_ids', 'residue_ids'))
    return _modeller.make_restraints(mdl, edat, aln, io, libs, *args)

  def define_symmetry(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('add_symmetry', 'symmetry_weight'))
    return _modeller.define_symmetry(mdl, *args)

  def pick_restraints(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('residue_span_range', 'restraint_sel_atoms', 'add_restraints', 'restraints_filter'))
    return _modeller.pick_restraints(mdl, *args)

  def condense_restraints(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.condense_restraints(mdl, *args)

  def add_restraint(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('restraint_parameters', 'atom_ids'))
    return _modeller.add_restraint(mdl, *args)

  def delete_restraint(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('atom_ids'))
    return _modeller.delete_restraint(mdl, *args)

  def reindex_restraints(self, logname, mdl, mdl2, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.reindex_restraints(mdl, mdl2, *args)

  def spline_restraints(self, logname, mdl, edat, libs, **vars):
    args = self.set_tops(logname, vars, ('residue_span_range', 'spline_dx', 'spline_range', 'spline_select', 'spline_min_points', 'output'))
    return _modeller.spline_restraints(mdl, edat, libs, *args)

  def read_restraints(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('file', 'add_restraints'))
    return _modeller.read_restraints(mdl, *args)

  def write_restraints(self, logname, mdl, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory', 'restraints_format'))
    return _modeller.write_restraints(mdl, *args)

  def read_sequence_db(self, logname, sdb, libs, **vars):
    args = self.set_tops(logname, vars, ('chains_list', 'seq_database_file', 'seq_database_format', 'clean_sequences', 'minmax_db_seq_len'))
    return _modeller.read_sequence_db(sdb, libs, *args)

  def write_sequence_db(self, logname, sdb, libs, **vars):
    args = self.set_tops(logname, vars, ('chains_list', 'seq_database_file', 'seq_database_format'))
    return _modeller.write_sequence_db(sdb, libs, *args)

  def sequence_search(self, logname, sdb, aln, io, libs, **vars):
    args = self.set_tops(logname, vars, ('search_randomizations', 'search_top_list', 'off_diagonal', 'overhang', 'gap_penalties_1d', 'signif_cutoff', 'rr_file', 'matrix_offset', 'fast_search_cutoff', 'data_file', 'search_group_list', 'search_sort', 'output', 'alignment_features', 'seq_database_file', 'local_alignment', 'fast_search'))
    return _modeller.sequence_search(sdb, aln, io, libs, *args)

  def seqfilter(self, logname, sdb, libs, **vars):
    args = self.set_tops(logname, vars, ('gap_penalties_1d', 'matrix_offset', 'rr_file', 'seqid_cut', 'max_diff_res', 'output_grp_file', 'output_cod_file'))
    return _modeller.seqfilter(sdb, libs, *args)

  def write(self, logname, **vars):
    args = self.set_tops(logname, vars, ('io_unit', 'objects'))
    return _modeller.top_write(*args)

  def read(self, logname, **vars):
    args = self.set_tops(logname, vars, ('io_unit'))
    return _modeller.top_read(*args)

  def open(self, logname, **vars):
    args = self.set_tops(logname, vars, ('io_unit', 'objects_file', 'output_directory', 'file_status', 'file_access'))
    return _modeller.top_open(*args)

  def close(self, logname, **vars):
    args = self.set_tops(logname, vars, ('io_unit'))
    return _modeller.top_close(*args)

  def read_parameters(self, logname, prm, gprsr, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'add_parameters'))
    return _modeller.read_parameters(prm, gprsr, libs, *args)

  def read_restyp_lib(self, logname, libs, **vars):
    args = self.set_tops(logname, vars, ('restyp_lib_file'))
    return _modeller.read_restyp_lib(libs, *args)

  def read_topology(self, logname, tpl, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'add_topology'))
    return _modeller.read_topology(tpl, libs, *args)

  def new_read_parameters(self, logname, prm, libs, **vars):
    args = self.set_tops(logname, vars, ('file'))
    return _modeller.new_read_parameters(prm, libs, *args)

  def make_topology_model(self, logname, tpl, libs, **vars):
    args = self.set_tops(logname, vars, ())
    return _modeller.make_topology_model(tpl, libs, *args)

  def write_topology_model(self, logname, tpl, libs, **vars):
    args = self.set_tops(logname, vars, ('file', 'output_directory'))
    return _modeller.write_topology_model(tpl, libs, *args)

