import top
from modeller.energy_data import energy_data
from modeller.io_data import io_data
import _modeller

class topcmds:
  aln = [None, None]
  mdl = [None, None]
  sdb = [None]
  prf = [None]
  den = [None]
  libs = None
  edat = None
  io = None
  gprsr = None

  def get_topvars(self, vars):
    args = []
    if not isinstance(vars, (list, tuple)):
      vars = (vars,)
    for var in vars:
      args.append(self.vars[var])
    return args

  def set_topvars(self, vars, keys):
    if not isinstance(keys, (list, tuple)):
      keys = (keys,)
    if not isinstance(vars, (list, tuple)):
      vars = (vars,)
    for i in range(len(keys)):
      self.vars[keys[i]] = vars[i]
  
  def get_edat(self):
    if self.edat == None:
      self.edat = energy_data()
    return self.edat

  def get_io(self):
    if self.io == None:
      self.io = io_data()
    return self.io

  def get_gprsr(self):
    if self.gprsr == None:
      self.gprsr = _modeller.new_group_restraints()
    return self.gprsr

  def get_aln(self, num=1):
    aln = self.aln[num - 1]
    if aln == None:
      aln = _modeller.new_alignment()
      self.aln[num - 1] = aln
    return aln

  def get_mdl(self, num=1):
    mdl = self.mdl[num - 1]
    if mdl == None:
      mdl = _modeller.new_model()
      _modeller.set_model_group_restraints(mdl, self.get_libs(),
                                           self.get_gprsr())
      self.mdl[num - 1] = mdl
    return mdl

  def get_sdb(self, num=1):
    sdb = self.sdb[num - 1]
    if sdb == None:
      sdb = _modeller.new_sequence_db()
      self.sdb[num - 1] = sdb
    return sdb

  def get_prf(self, num=1):
    prf = self.prf[num - 1]
    if prf == None:
      prf = _modeller.new_profile()
      self.prf[num - 1] = prf
    return prf

  def get_libs(self):
    if self.libs == None:
      self.libs = _modeller.new_libraries()
    return self.libs

  def get_tpl(self):
    return _modeller.get_libraries_topology(self.get_libs())

  def get_prm(self):
    return _modeller.get_libraries_parameters(self.get_libs())

  def get_den(self, num=1):
    den = self.den[num - 1]
    if den == None:
      den = _modeller.new_density()
      self.den[num - 1] = den
    return den

  def delete_alignment(self):
    aln = self.get_aln()
    _modeller.delete_alignment(aln)

  def read_alignment2(self):
    aln2 = self.get_aln(2)
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('align_codes2', 'atom_files2', 'file', 'remove_gaps', 'alignment_format', 'add_sequence', 'rewind_file', 'close_file'))
    outs = _modeller.read_alignment2(aln2, io, libs, *args)
    self.set_topvars(outs, ('end_of_file'))

  def read_model2(self):
    mdl2 = self.get_mdl(2)
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('file', 'model_format', 'model2_segment'))
    _modeller.read_model2(mdl2, aln, io, libs, *args)

  def write_model2(self):
    mdl2 = self.get_mdl(2)
    libs = self.get_libs()
    args = self.get_topvars(('file', 'output_directory', 'model_format', 'no_ter'))
    _modeller.write_model2(mdl2, libs, *args)

  def read_alignment(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('align_codes', 'atom_files', 'file', 'remove_gaps', 'alignment_format', 'add_sequence', 'rewind_file', 'close_file'))
    outs = _modeller.read_alignment(aln, io, libs, *args)
    self.set_topvars(outs, ('end_of_file'))

  def check_alignment(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    _modeller.check_alignment(aln, io, libs)

  def compare_alignments(self):
    aln = self.get_aln()
    aln2 = self.get_aln(2)
    _modeller.compare_alignments(aln, aln2)

  def sequence_to_ali(self):
    aln = self.get_aln()
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('atom_files', 'align_codes', 'add_sequence'))
    _modeller.sequence_to_ali(aln, mdl, libs, *args)

  def write_alignment(self):
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'output_directory', 'alignment_format', 'alignment_features', 'align_block', 'align_alignment'))
    _modeller.write_alignment(aln, libs, *args)

  def edit_alignment(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('overhang', 'edit_align_codes', 'base_align_codes', 'min_base_entries'))
    _modeller.edit_alignment(aln, io, libs, *args)

  def describe(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    _modeller.describe(aln, io, libs)

  def id_table(self):
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('matrix_file', 'output_directory'))
    _modeller.id_table(aln, libs, *args)

  def sequence_comparison(self):
    aln = self.get_aln()
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('rr_file', 'matrix_file', 'variability_file', 'output_directory', 'max_gaps_match'))
    _modeller.sequence_comparison(aln, mdl, libs, *args)

  def align(self):
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('off_diagonal', 'max_gap_length', 'local_alignment', 'matrix_offset', 'gap_penalties_1d', 'read_weights', 'write_weights', 'n_subopt', 'subopt_offset', 'weigh_sequences', 'smooth_prof_weight', 'align_what', 'weights_type', 'input_weights_file', 'output_weights_file', 'rr_file', 'overhang', 'align_block'))
    _modeller.align(aln, libs, *args)

  def align2d(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('overhang', 'align_block', 'rr_file', 'align_what', 'off_diagonal', 'max_gap_length', 'local_alignment', 'matrix_offset', 'gap_penalties_1d', 'gap_penalties_2d', 'surftyp', 'fit', 'fix_offsets', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file', 'n_subopt', 'subopt_offset', 'read_profile', 'input_profile_file', 'write_profile', 'output_profile_file', 'weigh_sequences', 'smooth_prof_weight', 'weights_type'))
    _modeller.align2d(aln, io, libs, *args)

  def malign(self):
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('rr_file', 'off_diagonal', 'local_alignment', 'matrix_offset', 'overhang', 'align_block', 'gap_penalties_1d'))
    _modeller.malign(aln, libs, *args)

  def align_consensus(self):
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('align_block', 'gap_penalties_1d', 'max_gap_length', 'read_weights', 'write_weights', 'weigh_sequences', 'input_weights_file', 'output_weights_file', 'weights_type', 'smooth_prof_weight'))
    _modeller.align_consensus(aln, libs, *args)

  def compare(self):
    aln = self.get_aln()
    edat = self.get_edat().modpt
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('compare_mode', 'fit', 'fit_atoms', 'matrix_file', 'output', 'asgl_output', 'refine_local', 'rms_cutoffs', 'distance_atoms'))
    _modeller.compare(aln, edat, io, libs, *args)

  def align3d(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('off_diagonal', 'overhang', 'local_alignment', 'matrix_offset', 'gap_penalties_3d', 'fit', 'fit_atoms', 'align3d_trf', 'output', 'align3d_repeat'))
    _modeller.align3d(aln, io, libs, *args)

  def malign3d(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('no_ter', 'off_diagonal', 'overhang', 'local_alignment', 'matrix_offset', 'gap_penalties_3d', 'fit', 'fit_atoms', 'output', 'write_whole_pdb', 'current_directory', 'write_fit', 'edit_file_ext'))
    _modeller.malign3d(aln, io, libs, *args)

  def salign(self):
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('residue_type2', 'no_ter', 'overhang', 'off_diagonal', 'matrix_offset', 'gap_penalties_1d', 'gap_penalties_2d', 'gap_penalties_3d', 'feature_weights', 'rms_cutoffs', 'fit', 'surftyp', 'fit_on_first', 'gap_function', 'align_block', 'max_gap_length', 'align_what', 'read_weights', 'write_weights', 'input_weights_file', 'output_weights_file', 'weigh_sequences', 'smooth_prof_weight', 'fix_offsets', 'substitution', 'comparison_type', 'matrix_comparison', 'alignment_type', 'edit_file_ext', 'weights_type', 'similarity_flag', 'bkgrnd_prblty_file', 'ext_tree', 'dendrogram_file', 'matrix_scaling_factor', 'auto_overhang', 'overhang_factor', 'overhang_auto_limit', 'local_alignment', 'improve_alignment', 'fit_atoms', 'output', 'write_whole_pdb', 'current_directory', 'write_fit', 'fit_pdbnam', 'rr_file', 'n_subopt', 'subopt_offset', 'align3d_trf', 'normalize_pp_scores', 'gap_gap_score', 'gap_residue_score', 'nsegm', 'matrix_offset_3d'))
    outs = _modeller.salign(aln, io, libs, *args)
    self.set_topvars(outs, ('aln_score'))

  def aln_to_prof(self):
    aln = self.get_aln()
    prf = self.get_prf()
    args = self.get_topvars(('clean_sequences'))
    _modeller.aln_to_prof(aln, prf, *args)

  def expand_alignment(self):
    aln = self.get_aln()
    args = self.get_topvars(('expand_control', 'root_name', 'file_id', 'file_ext'))
    _modeller.expand_alignment(aln, *args)

  def segment_matching(self):
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('rr_file', 'file', 'align_block', 'min_loop_length', 'segment_shifts', 'segment_growth_n', 'segment_growth_c', 'segment_cutoff', 'segment_report', 'output_directory', 'root_name', 'file_id', 'file_ext'))
    _modeller.segment_matching(aln, libs, *args)

  def read_density(self):
    den = self.get_den()
    args = self.get_topvars(('file', 'em_density_format', 'em_map_size', 'filter_type', 'voxel_size', 'resolution', 'filter_values', 'density_type'))
    _modeller.read_density(den, *args)

  def em_grid_search(self):
    den = self.get_den()
    args = self.get_topvars(('em_density_format', 'num_structures', 'dock_order', 'start_type', 'translate_type', 'number_of_steps', 'angular_step_size', 'temperature', 'best_docked_models', 'em_fit_output_file', 'em_pdb_name', 'chains_num'))
    _modeller.em_grid_search(den, *args)

  def make_schedule(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('library_schedule', 'residue_span_range', 'schedule_scale'))
    _modeller.make_schedule(mdl, *args)

  def read_schedule(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('file', 'schedule_scale'))
    _modeller.read_schedule(mdl, *args)

  def write_schedule(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('file', 'output_directory'))
    _modeller.write_schedule(mdl, *args)

  def energy(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    libs = self.get_libs()
    args = self.get_topvars(('deviation', 'asgl_output', 'normalize_profile', 'residue_span_range', 'output', 'file', 'output_directory', 'smoothing_window', 'viol_report_cut', 'viol_report_cut2', 'schedule_scale'))
    outs = _modeller.energy(mdl, edat, libs, *args)
    self.set_topvars(outs, ('molpdf'))

  def optimize(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    libs = self.get_libs()
    args = self.get_topvars(('optimization_method', 'init_velocities', 'temperature', 'md_time_step', 'min_atom_shift', 'cap_atom_shift', 'write_all_atoms', 'no_ter', 'trace_output', 'equilibrate', 'max_iterations', 'residue_span_range', 'md_return', 'output', 'id2', 'root_name', 'file_id', 'file_ext', 'output_directory'))
    outs = _modeller.optimize(mdl, edat, libs, *args)
    self.set_topvars(outs, ('molpdf'))

  def switch_trace(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('file', 'output_directory'))
    _modeller.switch_trace(mdl, *args)

  def debug_function(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    libs = self.get_libs()
    args = self.get_topvars(('residue_span_range', 'debug_function_cutoff', 'detailed_debugging'))
    _modeller.debug_function(mdl, edat, libs, *args)

  def assess_model(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('assess_method'))
    outs = _modeller.assess_model(mdl, libs, *args)
    self.set_topvars(outs, ('molpdf'))

  def assess_ga341(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    outs = _modeller.assess_ga341(mdl, libs)
    self.set_topvars(outs, ('molpdf'))

  def dendrogram(self):
    args = self.get_topvars(('matrix_file', 'cluster_cut'))
    _modeller.dendrogram(*args)

  def principal_components(self):
    args = self.get_topvars(('matrix_file', 'file'))
    _modeller.principal_components(*args)

  def system(self):
    args = self.get_topvars(('command'))
    _modeller.top_system(*args)

  def delete_file(self):
    args = self.get_topvars(('file'))
    _modeller.delete_file(*args)

  def inquire(self):
    args = self.get_topvars(('file', 'output_directory'))
    outs = _modeller.inquire(*args)
    self.set_topvars(outs, ('file_exists'))

  def read_atom_classes(self):
    gprsr = self.get_gprsr()
    args = self.get_topvars(('atom_classes_file'))
    _modeller.read_atom_classes(gprsr, *args)

  def read_group_restraints(self):
    gprsr = self.get_gprsr()
    libs = self.get_libs()
    args = self.get_topvars(('file'))
    _modeller.read_group_restraints(gprsr, libs, *args)

  def read_model(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('file', 'model_format', 'model_segment'))
    _modeller.read_model(mdl, aln, io, libs, *args)

  def write_model(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'output_directory', 'model_format', 'no_ter', 'write_all_atoms'))
    _modeller.write_model(mdl, libs, *args)

  def generate_topology(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('add_segment', 'sequence', 'patch_default'))
    _modeller.generate_topology(mdl, aln, io, libs, *args)

  def patch(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('residue_type', 'residue_ids'))
    _modeller.patch(mdl, libs, *args)

  def patch_ss_templates(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    _modeller.patch_ss_templates(mdl, aln, io, libs)

  def patch_ss_model(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    _modeller.patch_ss_model(mdl, libs)

  def mutate_model(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('residue_type'))
    _modeller.mutate_model(mdl, libs, *args)

  def build_model(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('build_method', 'initialize_xyz'))
    _modeller.build_model(mdl, libs, *args)

  def unbuild_model(self):
    mdl = self.get_mdl()
    _modeller.unbuild_model(mdl)

  def transfer_xyz(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('cluster_cut', 'cluster_method'))
    _modeller.transfer_xyz(mdl, aln, io, libs, *args)

  def transfer_res_numb(self):
    mdl = self.get_mdl()
    mdl2 = self.get_mdl(2)
    aln = self.get_aln()
    libs = self.get_libs()
    _modeller.transfer_res_numb(mdl, mdl2, aln, libs)

  def rename_segments(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('segment_ids', 'renumber_residues'))
    _modeller.rename_segments(mdl, *args)

  def pick_atoms(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('pick_atoms_set', 'sphere_radius', 'selection_slab', 'gap_extension', 'minmax_loop_length', 'res_types', 'atom_types', 'selection_mode', 'selection_search', 'selection_status', 'selection_from', 'sphere_center', 'selection_segment'))
    _modeller.pick_atoms(mdl, aln, libs, *args)

  def pick_hot_atoms(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    libs = self.get_libs()
    args = self.get_topvars(('extend_hot_spot', 'selection_mode', 'residue_span_range', 'pick_hot_cutoff', 'viol_report_cut'))
    _modeller.pick_hot_atoms(mdl, edat, libs, *args)

  def randomize_xyz(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('deviation'))
    _modeller.randomize_xyz(mdl, libs, *args)

  def iupac_model(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    _modeller.iupac_model(mdl, libs)

  def reorder_atoms(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    _modeller.reorder_atoms(mdl, libs)

  def rotate_dihedrals(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('deviation', 'change', 'dihedrals'))
    _modeller.rotate_dihedrals(mdl, libs, *args)

  def orient_model(self):
    mdl = self.get_mdl()
    _modeller.orient_model(mdl)

  def rotate_model(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('translation', 'rotation_matrix', 'rotation_axis', 'rotation_angle'))
    _modeller.rotate_model(mdl, *args)

  def write_data(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    libs = self.get_libs()
    args = self.get_topvars(('surftyp', 'neighbor_cutoff', 'accessibility_type', 'output', 'file', 'probe_radius', 'psa_integration_step'))
    _modeller.write_data(mdl, edat, libs, *args)

  def write_pdb_xref(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'output_directory', 'model_segment'))
    _modeller.write_pdb_xref(mdl, aln, libs, *args)

  def make_region(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('atom_accessibility', 'region_size'))
    _modeller.make_region(mdl, libs, *args)

  def color_aln_model(self):
    mdl = self.get_mdl()
    aln = self.get_aln()
    _modeller.color_aln_model(mdl, aln)

  def superpose(self):
    mdl = self.get_mdl()
    mdl2 = self.get_mdl(2)
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('swap_atoms_in_res', 'reference_atom', 'reference_distance', 'superpose_refine', 'fit', 'refine_local', 'rms_cutoffs'))
    _modeller.superpose(mdl, mdl2, aln, libs, *args)

  def make_chains(self):
    mdl = self.get_mdl()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'structure_types', 'minimal_resolution', 'minimal_chain_length', 'max_nonstdres', 'chop_nonstd_terminii', 'minimal_stdres', 'alignment_format'))
    _modeller.make_chains(mdl, libs, *args)

  def read_profile(self):
    prf = self.get_prf()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'profile_format'))
    _modeller.read_profile(prf, libs, *args)

  def write_profile(self):
    prf = self.get_prf()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'n_prof_iterations', 'gap_penalties_1d', 'matrix_offset', 'profile_format', 'rr_file'))
    _modeller.write_profile(prf, libs, *args)

  def prof_to_aln(self):
    prf = self.get_prf()
    aln = self.get_aln()
    libs = self.get_libs()
    args = self.get_topvars(('append_aln'))
    _modeller.prof_to_aln(prf, aln, libs, *args)

  def profile_profile_scan(self):
    prf = self.get_prf()
    libs = self.get_libs()
    args = self.get_topvars(('profile_list_file', 'matrix_offset', 'profile_format', 'rr_file', 'gap_penalties_1d', 'matrix_scaling_factor', 'max_aln_evalue', 'aln_base_filename', 'score_statistics', 'output_alignments', 'output_scores', 'output_score_file', 'pssm_weights_type', 'write_summary', 'summary_file'))
    _modeller.profile_profile_scan(prf, libs, *args)

  def build_profile(self):
    prf = self.get_prf()
    sdb = self.get_sdb()
    libs = self.get_libs()
    args = self.get_topvars(('gap_penalties_1d', 'matrix_offset', 'rr_file', 'n_prof_iterations', 'max_aln_evalue', 'matrix_scaling_factor', 'check_profile', 'output_scores', 'output_score_file', 'gaps_in_target', 'score_statistics', 'pssm_weights_type', 'write_pssm', 'pssm_file'))
    _modeller.build_profile(prf, sdb, libs, *args)

  def make_restraints(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('residue_span_range', 'residue_grouping', 'restraint_type', 'restraint_sel_atoms', 'restraint_group', 'basis_pdf_weight', 'distance_rsr_model', 'maximal_distance', 'basis_relative_weight', 'spline_on_site', 'residue_span_sign', 'intersegment', 'add_restraints', 'dih_lib_only', 'spline_dx', 'spline_min_points', 'spline_range', 'mnch_lib', 'accessibility_type', 'restraint_stdev', 'restraint_stdev2', 'sheet_h_bonds', 'surftyp', 'restraint_parameters', 'distance_atoms', 'atom_ids', 'residue_ids'))
    _modeller.make_restraints(mdl, edat, aln, io, libs, *args)

  def define_symmetry(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('add_symmetry', 'symmetry_weight'))
    _modeller.define_symmetry(mdl, *args)

  def pick_restraints(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('residue_span_range', 'restraint_sel_atoms', 'add_restraints', 'restraints_filter'))
    _modeller.pick_restraints(mdl, *args)

  def condense_restraints(self):
    mdl = self.get_mdl()
    _modeller.condense_restraints(mdl)

  def add_restraint(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('restraint_parameters', 'atom_ids'))
    _modeller.add_restraint(mdl, *args)

  def delete_restraint(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('atom_ids'))
    _modeller.delete_restraint(mdl, *args)

  def reindex_restraints(self):
    mdl = self.get_mdl()
    mdl2 = self.get_mdl(2)
    _modeller.reindex_restraints(mdl, mdl2)

  def spline_restraints(self):
    mdl = self.get_mdl()
    edat = self.get_edat().modpt
    libs = self.get_libs()
    args = self.get_topvars(('residue_span_range', 'spline_dx', 'spline_range', 'spline_select', 'spline_min_points', 'output'))
    _modeller.spline_restraints(mdl, edat, libs, *args)

  def read_restraints(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('file', 'add_restraints'))
    _modeller.read_restraints(mdl, *args)

  def write_restraints(self):
    mdl = self.get_mdl()
    args = self.get_topvars(('file', 'output_directory', 'restraints_format'))
    _modeller.write_restraints(mdl, *args)

  def read_sequence_db(self):
    sdb = self.get_sdb()
    libs = self.get_libs()
    args = self.get_topvars(('chains_list', 'seq_database_file', 'seq_database_format', 'clean_sequences', 'minmax_db_seq_len'))
    _modeller.read_sequence_db(sdb, libs, *args)

  def write_sequence_db(self):
    sdb = self.get_sdb()
    libs = self.get_libs()
    args = self.get_topvars(('chains_list', 'seq_database_file', 'seq_database_format'))
    _modeller.write_sequence_db(sdb, libs, *args)

  def sequence_search(self):
    sdb = self.get_sdb()
    aln = self.get_aln()
    io = self.get_io().modpt
    libs = self.get_libs()
    args = self.get_topvars(('search_randomizations', 'search_top_list', 'off_diagonal', 'overhang', 'gap_penalties_1d', 'signif_cutoff', 'rr_file', 'matrix_offset', 'fast_search_cutoff', 'data_file', 'search_group_list', 'search_sort', 'output', 'alignment_features', 'seq_database_file', 'local_alignment', 'fast_search'))
    _modeller.sequence_search(sdb, aln, io, libs, *args)

  def seqfilter(self):
    sdb = self.get_sdb()
    libs = self.get_libs()
    args = self.get_topvars(('gap_penalties_1d', 'matrix_offset', 'rr_file', 'seqid_cut', 'max_diff_res', 'output_grp_file', 'output_cod_file'))
    _modeller.seqfilter(sdb, libs, *args)

  def write(self):
    args = self.get_topvars(('io_unit', 'objects'))
    _modeller.top_write(*args)

  def read(self):
    args = self.get_topvars(('io_unit'))
    outs = _modeller.top_read(*args)
    self.set_topvars(outs, ('record'))

  def open(self):
    args = self.get_topvars(('io_unit', 'objects_file', 'output_directory', 'file_status', 'file_access'))
    outs = _modeller.top_open(*args)
    self.set_topvars(outs, ('number_lines'))

  def close(self):
    args = self.get_topvars(('io_unit'))
    _modeller.top_close(*args)

  def read_parameters(self):
    prm = self.get_prm()
    gprsr = self.get_gprsr()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'add_parameters'))
    _modeller.read_parameters(prm, gprsr, libs, *args)

  def read_restyp_lib(self):
    libs = self.get_libs()
    args = self.get_topvars(('restyp_lib_file'))
    _modeller.read_restyp_lib(libs, *args)

  def read_topology(self):
    tpl = self.get_tpl()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'add_topology'))
    _modeller.read_topology(tpl, libs, *args)

  def new_read_parameters(self):
    prm = self.get_prm()
    libs = self.get_libs()
    args = self.get_topvars(('file'))
    _modeller.new_read_parameters(prm, libs, *args)

  def make_topology_model(self):
    tpl = self.get_tpl()
    libs = self.get_libs()
    _modeller.make_topology_model(tpl, libs)

  def write_topology_model(self):
    tpl = self.get_tpl()
    libs = self.get_libs()
    args = self.get_topvars(('file', 'output_directory'))
    _modeller.write_topology_model(tpl, libs, *args)

