from topology import topology
from parameters import parameters
import util.top as top
from modeller.util.modobject import modobject
import _modeller

class libraries(modobject):

    def __init__(self, env):
        self.add_members(('_libraries__modpt', '_libraries__topology',
                          '_libraries__parameters', 'env', 'top'))
        self.env = env
        self.top = top.top(self.env)
        self.__modpt = _modeller.new_libraries()
        self.__topology = topology(self)
        self.__parameters = parameters(self)
        _modeller.libraries_read_libs(self.modpt, self.env.restyp_lib_file,
                                      self.env.rand_seed)

    def __del__(self):
        _modeller.free_libraries(self.modpt)

    def __get_modpt(self):
        return self.__modpt
    def __get_topology(self):
        return self.__topology
    def __get_parameters(self):
        return self.__parameters
    def __get_rand_seed(self):
        return _modeller.get_libraries_rand_seed(self.modpt)
    def __set_rand_seed(self, val):
        _modeller.set_libraries_rand_seed(self.modpt, val)

    modpt = property(__get_modpt)
    topology = property(__get_topology)
    parameters = property(__get_parameters)
    rand_seed = property(__get_rand_seed, __set_rand_seed)
