# Example for: model.write_pdb_xref()

# This writes out information useful for relating PDB residue numbers with
# residue indices.

log.verbose()
env = environ()

mdl = model(env, file='2abx.atm', model_segment=('FIRST:@', 'END:'))
aln = alignment(env)
aln.append_model(mdl, align_codes='2abx')

# if not found, 1, NRES used
mdl.write_pdb_xref(aln, file='2abx.xref1', model_segment=('FIRST:@', 'END:'))

# You can use string resid's
mdl.write_pdb_xref(aln, file='2abx.xref2', model_segment=('1:', '50:'))

# You can use integer resid's
mdl.write_pdb_xref(aln, file='2abx.xref3', model_segment=('!2', '!50'))

# You can even use the alignment specs, but not with codes that start with '!'
mdl.write_pdb_xref(aln, file='2abx.xref4', model_segment=('2abx', '2abx'))

# You can mix the specs
mdl.write_pdb_xref(aln, file='2abx.xref5', model_segment=('!2', '50:'))
mdl.write_pdb_xref(aln, file='2abx.xref6', model_segment=('!2', 'END:'))
