/* Special handling for exceptions raised by mod_file_open */
%exception mod_file_open {
  $action
  if (!result && check_for_error()) {
    SWIG_fail;
  }
}

/* Don't wrap the mod_file structure; should be treated as opaque */
%ignore mod_file;

/* Provide our own implementation for mod_file_open_stream */
%ignore mod_file_open_stream;

%{
#if PY_VERSION_HEX < 0x03000000
/* Adapter to use cStringIO read with mod_file objects */
static size_t cstr_readfunc(void *data, char *buffer, size_t bufsize, int *ierr)
{
  char *buf;
  int len;
  PyObject *obj = (PyObject *)data;
  len = PycStringIO->cread(obj, &buf, (Py_ssize_t)bufsize);
  if (PyErr_Occurred()) {
    *ierr = 1;
    return 0;
  } else {
    *ierr = 0;
    if ((size_t)len == bufsize) {
      memcpy(buffer, buf, len);
    }
  }
  return (size_t)len;
}

/* Adapter to use cStringIO write with mod_file objects */
static void cstr_writefunc(void *data, const char *buffer, size_t bufsize,
                           int *ierr)
{
  PyObject *obj = (PyObject *)data;
  PycStringIO->cwrite(obj, (char *)buffer, (Py_ssize_t)bufsize);
  *ierr = (PyErr_Occurred() != NULL);
}

/* Release the reference to the underlying cStringIO object */
static void cstr_freefunc(void *data)
{
  Py_DECREF((PyObject *)data);
}
#else

/* For Python 3, no C API for file-like objects, so call the Python methods
   instead */
struct FileMethods {
  PyObject *read_method, *write_method;
};

static size_t pyfile_readfunc(void *data, char *buffer, size_t bufsize,
                              int *ierr)
{
  struct FileMethods *methods = (struct FileMethods *)data;
  static char fmt[] = "(i)";

  PyObject *result = PyObject_CallFunction(methods->read_method, fmt,
                                           (int)bufsize);
  if (!result) {
    *ierr = 1;
    return 0;
  } else if (PyBytes_Check(result)) {
    Py_ssize_t len = PyBytes_Size(result);
    if ((size_t)len == bufsize) {
      memcpy(buffer, PyBytes_AsString(result), bufsize);
    }
    *ierr = 0;
    return (size_t)len;
  } else {
    PyErr_SetString(PyExc_TypeError, "Python file-like object read method "
                    "should return a 'bytes' object");
    *ierr = 1;
    return 0;
  }
}

static void pyfile_writefunc(void *data, const char *buffer, size_t bufsize,
                             int *ierr)
{
  struct FileMethods *methods = (struct FileMethods *)data;
  static char fmt[] = "(y#)";

  PyObject *result = PyObject_CallFunction(methods->write_method, fmt,
                                           buffer, (int)bufsize);
  if (!result) {
    *ierr = 1;
  } else {
    *ierr = 0;
    Py_DECREF(result);
  }
}

static void pyfile_freefunc(void *data)
{
  struct FileMethods *methods = (struct FileMethods *)data;
  Py_DECREF(methods->read_method);
  Py_DECREF(methods->write_method);
  g_free(methods);
}
#endif
%}

%inline %{
/* Open a mod_file object that accesses a Python file-like object */
static struct mod_file *mod_file_open_python(PyObject *obj, int *ierr)
{
#if PY_VERSION_HEX < 0x03000000
  if (!PycStringIO) {
    PyErr_SetString(PyExc_ImportError, "Could not import cStringIO module");
    *ierr = 1;
    return NULL;
  } else if (!PycStringIO_OutputCheck(obj) && !PycStringIO_InputCheck(obj)) {
    PyErr_SetString(PyExc_TypeError, "Expecting a cStringIO object");
    *ierr = 1;
    return NULL;
  } else {
    *ierr = 0;
    Py_INCREF(obj);
    return mod_file_open_stream(cstr_readfunc, cstr_writefunc, cstr_freefunc,
                                obj);
  }
#else
  PyObject *read_method, *write_method;
  struct FileMethods *methods;

  read_method = PyObject_GetAttrString(obj, "read");
  if (!read_method) {
    PyErr_SetString(PyExc_TypeError,
                    "Expecting an object with a 'read' method");
    *ierr = 1;
    return NULL;
  }

  write_method = PyObject_GetAttrString(obj, "write");
  if (!write_method) {
    Py_DECREF(read_method);
    PyErr_SetString(PyExc_TypeError,
                    "Expecting an object with a 'write' method");
    *ierr = 1;
    return NULL;
  }

  methods = g_malloc(sizeof(struct FileMethods));
  methods->read_method = read_method;
  methods->write_method = write_method;
  *ierr = 0;
  return mod_file_open_stream(pyfile_readfunc, pyfile_writefunc,
                              pyfile_freefunc, methods);
#endif
}  
%} /* inline */

%include "../include/mod_file.h"
