from modeller import *

env = environ()
env.io.atom_files_directory = '../atom_files'
env.libs.topology.read(file='$(LIB)/top_heav.lib')
env.libs.parameters.read(file='$(LIB)/par.lib')

mdl = model(env, file='1fdx')

# New empty selection
s = selection()

# Add all atoms from residues 4 through 10 inclusive (PDB numbering)
s.add(mdl.residue_range('4', '10'))

# Selection of all atoms currently within 5A of atom CA:1 (this destroys the
# previous selection):
s = mdl.atoms['CA:1'].select_sphere(5)

# Is the CB:1 atom in the selection?
print mdl.atoms['CB:1'] in s

# All atoms currently within 5A of atom CA:1, OR currently within 3A of the
# point (1,10,1):
s = mdl.atoms['CA:1'].select_sphere(5) | mdl.point(1,10,1).select_sphere(3)

# All atoms currently within 5A of atom CA:1, AND also currently within 3A
# of the point (1,10,1):
s = mdl.atoms['CA:1'].select_sphere(5) & mdl.point(1,10,1).select_sphere(3)

# All atoms currently within 5A of atom CA:1, OR currently within 3A of the
# point (1,10,1), but not BOTH:
s = mdl.atoms['CA:1'].select_sphere(5) ^ mdl.point(1,10,1).select_sphere(3)

# Create a selection containing the CA atom from residue 1,
# and all of residue 2 (PDB numbering)
s = selection(mdl.atoms['CA:1'], mdl.residues['2'])

# All residues EXCEPT 5-10 (i.e. all atom selection minus the selection
# of residues 5-10, otherwise known as an inverted selection):
s = selection(mdl) - selection(mdl.residue_range('5', '10'))

# Selection of residues 1, 4, 8 and 10-15 (PDB numbering):
s = selection(mdl.residues['1'], mdl.residues['4'], mdl.residues['8'],
              mdl.residue_range('10', '15'))

# Print the center of mass (note: not mass weighted)
print s.mass_center

# Rotate by 90 degrees about the z axis through the origin (0,0,0)
# (right handed rotation)
s.rotate_origin([0,0,1], 90)

# The same thing, except that the axis passes through the center of mass:
s.rotate_mass_center([0,0,1], 90)

# Translate by 5 angstroms along the x axis
s.translate([5.0, 0, 0])

# Equivalent (but less efficient, as it involves calculating the COM)
s.x += 5.0
