import xdrlib

try:
    import cPickle as pickle
except ImportError:
    import pickle

class heartbeat:
    pass

class data_type:
    desc = "generic data"
    def recv(self, buffer):
        pass
    def send(self, obj):
        pass
    def __str__(self):
        return self.desc

class netstring(data_type):
    code = 'S'
    obj = str
    desc = "string"
    def recv(self, buffer):
        p = xdrlib.Unpacker(buffer[1:])
        obj = p.unpack_string()
        return (obj, buffer[1+p.get_position():])
    def send(self, obj):
        p = xdrlib.Packer()
        p.pack_string(obj)
        return self.code + p.get_buffer()

class netinteger(data_type):
    code = 'I'
    obj = int
    desc = "integer"
    def recv(self, buffer):
        p = xdrlib.Unpacker(buffer[1:])
        obj = p.unpack_int()
        return (obj, buffer[1+p.get_position():])
    def send(self, obj):
        p = xdrlib.Packer()
        p.pack_int(obj)
        return self.code + p.get_buffer()

class netfloat(data_type):
    code = 'F'
    obj = float
    desc = "floating point"
    def recv(self, buffer):
        p = xdrlib.Unpacker(buffer[1:])
        obj = p.unpack_float()
        return (obj, buffer[1+p.get_position():])
    def send(self, obj):
        p = xdrlib.Packer()
        p.pack_float(obj)
        return self.code + p.get_buffer()

class netpickle(data_type):
    code = 'P'
    obj = None
    desc = "Python pickled object"
    def recv(self, buffer):
        p = xdrlib.Unpacker(buffer[1:])
        obj = p.unpack_string()
        return (pickle.loads(obj), buffer[1+p.get_position():])
    def send(self, obj):
        p = xdrlib.Packer()
        p.pack_string(pickle.dumps(obj, -1))
        return self.code + p.get_buffer()

class netcommand(netstring):
    code = 'C'
    desc = "command"

typemap = {}
cmdmap = {}
for name in dir():
    var = eval(name)
    try:
        if issubclass(var, data_type) and var is not data_type:
            exec("%s = %s()" % (name, name))
            var = eval(name)
            cmdmap[var.code] = var
            typemap[var.obj] = var
    except TypeError:
        pass
