from topology import topology
from parameters import parameters
from modeller.util.modobject import modobject
import _modeller

__docformat__ = "epytext en"

class libraries(modobject):
    """All library information, such as topology and parameter files, and
       random number state."""

    __modpt = None
    __restyp_lib_file = None
    __rand_seed = None

    def __init__(self, restyp_lib, rand_seed):
        self.__modpt = _modeller.mod_libraries_new(self)
        self.__restyp_lib_file = restyp_lib
        self.__rand_seed = rand_seed
        self.__read_libs()

    def __read_libs(self):
        _modeller.mod_libraries_read_libs(self.modpt, self.__restyp_lib_file,
                                          self.__rand_seed)

    def __getstate__(self):
        d = modobject.__getstate__(self)
        d['_libraries__rand_state'] = self.rand_state
        return d

    def __setstate__(self, d):
        r = d.pop('_libraries__rand_state')
        self.__dict__.update(d)
        self.__modpt = _modeller.mod_libraries_new(self)
        self.__read_libs()
        self.rand_state = r

    def __del__(self):
        if self.__modpt:
            _modeller.mod_libraries_free(self.__modpt)

    def random_number(self):
        """Get the next random number between 0 and 1 from Modeller's internal
           random number generator."""
        return _modeller.mod_random_number(self.modpt)

    def random_perturb(self, n):
        """Perturb the internal random number generator by some amount, n."""
        return _modeller.mod_random_perturb(self.modpt, n)

    def __get_modpt(self):
        return self.__modpt
    def __get_topology(self):
        return topology(self)
    def __get_parameters(self):
        return parameters(self)
    def __get_rand_seed(self):
        return _modeller.mod_libraries_rand_seed_get(self.modpt)
    def __set_rand_seed(self, val):
        _modeller.mod_libraries_rand_seed_set(self.modpt, val)
    def __get_rand_state(self):
        return _modeller.mod_libraries_randstate_get(self.modpt)
    def __set_rand_state(self, val):
        _modeller.mod_libraries_randstate_set(self.modpt, val)

    modpt = property(__get_modpt)
    topology = property(__get_topology, doc="Topology information")
    parameters = property(__get_parameters, doc="Parameter information")
    rand_seed = property(__get_rand_seed, __set_rand_seed, doc="Random seed")
    rand_state = property(__get_rand_state, __set_rand_state,
                          doc="Random number generator state")
