from modeller import *

log.verbose()
env = environ()

struct='../step4_model/TvLDH.B99990001.pdb'
map='TvLDH.10A.mrc'  
resolution=10.0  
box_size=48 
apix=1.88
x=-26.742; y=-9.5205; z=-10.375 #origin
steps=20

# Read in cryo-EM density map
den = density(env, file=map, em_density_format='MRC',
              voxel_size=apix, resolution=resolution, em_map_size=box_size,
              density_type='GAUSS', px=x,py=y,pz=z)

# Fit the PDB file into the map by MC simulated annealing
den.grid_search(em_density_format='MRC', num_structures=1,
                em_pdb_name=struct, chains_num=[1],
                start_type='CENTER', number_of_steps=steps,
                angular_step_size=30., temperature=100.,
                best_docked_models=1, translate_type='RANDOM',
                em_fit_output_file='modem.log')
