from modeller import *
from modeller.automodel import *

# Override the regular loopmodel class to select our own loops
class MyLoop(loopmodel):
    # This routine picks the residues to be refined by loop modeling
    def select_loop_atoms(self):
        # One loop from residues 93 to 100 inclusive
        return selection(self.residue_range('93:', '100:'))

env = environ()

# Build 5 loop models from TvLD_1_1.pdb, and assess each one with DOPE
a = MyLoop(env, inimodel='../step6_fit/TvLD_1_1.pdb',
           sequence='TvLDH', loop_assess_methods=assess.DOPE)
a.loop.starting_model = 1
a.loop.ending_model = 5
a.make()
