from modeller import *

env = environ()
env.io.atom_files_directory = ['.', '../atom_files']

native = model(env, file='1ake')
a = selection(native).only_atom_types('CA')
fnames = ['1ake_init.pdb', 'final1_mdcg.pdb']
rms = []
for f in fnames:
    # Superpose each structure onto native, and get the RMS
    m2 = model(env, file=f)
    aln = alignment(env)
    aln.append_model(native, align_codes='native', atom_files='native')
    aln.append_model(m2, align_codes='fit', atom_files='fit')
    rms.append(a.superpose(m2, aln).rms)

print
print "%-40s %8s" % ('Filename', 'RMSD')
for f, rms in zip(fnames, rms):
    print "%-40s %8.2f" % (f, rms)
