# Example for: model.rename_segments()

# This will assign new PDB single-character chain id's to all the chains
# in the input PDB file (here there are two 'chains': protein and the HETATM
# water molecules).

from modeller import *

# Read the MODEL with all HETATM and water records (so there are two 'chains'):
env = environ()
env.io.atom_files_directory = ['../atom_files']
env.io.hetatm = True
env.io.water = True

mdl = model(env, file='1fas')
# Assign new segment names and write out the new model:
mdl.rename_segments(segment_ids=('X', 'Y'))
mdl.write(file='1fas.ini')
