from modeller import *

env = environ()
env.io.atom_files_directory = ['.', 'atom_files']

# Make a simple 1:1 alignment of 7 template structures
aln = alignment(env)
for (pdb, chain) in (('1b8p', 'A'), ('1y7t', 'A'), ('1civ', 'A'),
                     ('5mdh', 'A'), ('7mdh', 'A'), ('3d5t', 'A'),
                     ('1smk', 'A')):
    m = model(env, file=pdb, model_segment=('FIRST:'+chain, 'LAST:'+chain))
    aln.append_model(m, atom_files=pdb, align_codes=pdb+chain)

# Sequence alignment
aln.malign()

# Structure alignment
aln.malign3d()

# Report details of the sequence/structure alignment
aln.compare_structures()
aln.id_table(matrix_file='family.mat')
env.dendrogram(matrix_file='family.mat', cluster_cut=-1.0)
