#!/bin/sh -f

# Function to guess Unix system architecture from 'uname' output
guess_arch () {
  U_M=`uname -m 2>/dev/null` || U_M=UNK
  U_S=`uname -s 2>/dev/null` || U_S=UNK
  U_P=`uname -p 2>/dev/null` || U_P=UNK

  MACHID=${U_M}:${U_S}:${U_P}

  ARCH="unknown"
  PREF="unknown"
  case "${MACHID}" in
    i686:Linux:*)
      # Linux Pentium-class PC
      ARCH="i386-intel8, i386-intel, i386-nag, i386-pgi, i386-absoft, i386-w32, i386-gnu"
      PREF="i386-intel8"
      ;;
    x86_64:Linux:*)
      # Linux Opteron or EM64T (64-bit) PC
      ARCH="x86_64-intel8"
      ;;
    ia64:Linux:*)
      # Linux Itanium-class (64-bit) PC
      ARCH="ia64-intel8, ia64-intel"
      PREF="ia64-intel8"
      ;;
    *:Darwin:powerpc)
      # Darwin (Mac OS X)
      ARCH="mac10v4-xlf"
      ;;
    alpha:*:alpha)
      # Alpha box
      ARCH="alpha"
      ;;
    *:AIX:powerpc)
      # IBM AIX box
      ARCH="rs6000"
      ;;
    *:IRIX*:mips)
      # Silicon Graphics workstation
      ARCH="iris4d"
      ;;
    *:SunOS:sparc)
      # Sun Solaris running on the Sparc architecture
      ARCH="sun4"
      ;;
  esac
  if [ "${PREF}" = "unknown" ]; then
    PREF=${ARCH}
  fi
}

guess_arch

if [ "$1" = "set" ]; then
  echo ${PREF}
fi
