import unittest
import os
import modpipe.test
from modpipe.scripts import clustermod

class ClusterModTests(modpipe.test.TestCase):

    def test_clustermod(self):
        """Check clustermod script"""
        listfile = 'test.list'
        clsfile = 'test.cls'
        repfile = 'test.rep'
        lrgfile = 'test.lrg'
        cmpfile = 'test.cmp'
        print >> file(listfile, 'w'), "pdb1apx.ent\npdb1hv9.ent"
        self.run_script('scripts', clustermod,
                        ['-i', listfile, '-d', '../db/pdb',
                         '--clsfile', clsfile, '--repfile', repfile,
                         '--lrgfile', lrgfile, '--cmpfile', cmpfile])
        for f, expected_wc in ((clsfile, 2), (cmpfile, 4), (lrgfile, 1),
                               (repfile, 2)):
            wc = len(file(f).readlines())
            self.assertEqual(wc, expected_wc)
        for f in (listfile, clsfile, repfile, lrgfile, cmpfile):
            os.unlink(f)

if __name__ == '__main__':
    unittest.main()
