# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

package PLLib::Email;
require Exporter;
@ISA    = qw(Exporter);
@EXPORT = qw( ValidateEmail );


use strict;
use PLLib::Utils;

sub ValidateEmail {

   # --- Get subroutine name
   my $subname = GetSubrName();

   # --- Check arguments
   my $nargs = 1;

   unless ( scalar(@_) == $nargs ){
      print "${subname}__D> Insufficient arguments\n";
      return;
   }

   # --- Reassign input arguments
   my $email = $_[0];

   # --- Check that this is a valid email address format
   #     Note: this only checks for the format, not the
   #     address
   my @emails=split(/\,/,$email);
   foreach $email (@emails) {
       print STDERR "Email address to validate: $email\n";
       return unless ( $email =~ m/^[\w-.]+@[\w-]+\.[\w-]+((\.[\w-]+)*)?$/ );
   }

   # --- Return success
   return 1;
}

