# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.


from modeller import *
from modeller.automodel import *

class automodeloutput:
    def __init__(self, outputs):
        self.outputs = outputs
        # Currently relevant keys
        self.relkeys = ['molpdf', 'name', 'GA341 score', 'failure',
                        'DOPE-HR score', 'Normalized DOPE score',
                        'DOPE score', 'num']
        # Sortable keys
        self.srtkeys = ['molpdf', 'DOPE-HR score', 'Normalized DOPE score',
                        'DOPE score']
        # Keys to sort in ascending order
        self.asckeys = ['DOPE-HR score', 'Normalized DOPE score', 'DOPE score']
        # Keys to sort in ascending order
        self.deskeys = ['DOPE-HR score', 'Normalized DOPE score', 'DOPE score']


    def expand_GA341(self):
        """Since the GA341 scores are stored as a list,
        separate them into individal key:value pairs."""
        for i in range(0, len(self.outputs)):
            if self.outputs[i]['failure']:
                continue
            self.outputs[i]['Compactness'] = self.outputs[i]['GA341 score'][1]
            self.outputs[i]['energy_pair'] = self.outputs[i]['GA341 score'][2]
            self.outputs[i]['energy_surf'] = self.outputs[i]['GA341 score'][3]
            self.outputs[i]['energy_comb'] = self.outputs[i]['GA341 score'][4]
            self.outputs[i]['z_pair']      = self.outputs[i]['GA341 score'][5]
            self.outputs[i]['z_surf']      = self.outputs[i]['GA341 score'][6]
            self.outputs[i]['z_comb']      = self.outputs[i]['GA341 score'][7]
            # Do this last so that you don't overwrite it
            self.outputs[i]['GA341 score'] = self.outputs[i]['GA341 score'][0]

        self.relkeys.extend(['Compactness', 'energy_pair', 'energy_surf',
                             'energy_comb', 'z_pair', 'z_surf', 'z_comb'])
        self.srtkeys.extend(['Compactness', 'energy_pair', 'energy_surf',
                             'energy_comb', 'z_pair', 'z_surf', 'z_comb',
                              'GA341 score'])
        self.asckeys.extend(['Compactness', 'energy_pair', 'energy_surf',
                             'energy_comb', 'z_pair', 'z_surf', 'z_comb'])
        self.deskeys.extend(['GA341 score'])


    def trim_outputs(self):
        """Parse the outputs list and create a new version that
        is suitable for sorting and that contains only the
        relevant scores."""
        for mdl in self.outputs:
            for k in mdl.keys():
                if k not in self.relkeys:
                    del mdl[k]


    def __fetch_score(self, score):
        """Run through the outputs and return a dict containing
        the model number and the chosen score"""
        d = {}
        for m in self.outputs:
            k = m['name']
            v = m[score]
            d[k] = v
        return d


    def sort_outputs_by_score(self, score):
        """Sort the outputs list by a specified score."""
        if score not in self.relkeys:
            print "Unknown score supplied for selection: ", score
            print "Allowed values are: ", repr(self.srtkeys)
            raise KeyError
        inp = [(mdl[score], mdl) for mdl in self.outputs]
        inp.sort()
        if score in self.deskeys:
            inp.reverse()
        self.outputs = [y for (x, y) in inp]


    def select_best_model_by(self, score):
        """Parse the output from automodel to select the
        best model according to the speciied score."""
        self.sort_outputs_by_score(score)
        self.keep_only_best_model()


    def keep_only_best_model(self):
        """Keep only the best model (top of the stack in a sorted
        list) and delete the rest."""
        del self.outputs[1:]


    def get_outputs(self):
        """Return the current state of the outputs list."""
        return self.outputs
