#!/usr/bin/python
# This file is part of ModPipe, Copyright 1997-2010 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

from modeller import *
import modpipe.pdbutils
import modpipe.version
from modpipe.scripts.getNO import calculate_no
from optparse import OptionParser
import os, sys

def main():
    parser = OptionParser(version=modpipe.version.message())

    parser.set_usage("""This script is a batch version of
 getNO.py to run on the cluster.

 Usage: %prog [options]

 Run `%prog -h` for help information
 """)

    parser.set_defaults(moddir='',
                        native='',
                        natchn='')

    parser.add_option("-d", dest="moddir",
                      help="Directory with the models")
    parser.add_option("-n", dest="native",
                      help="PDB code of native")
    parser.add_option("-c", dest="natchn",
                      help="Chain ID of native")
    pdb = modpipe.pdbutils.get_pdb_repository(include_local=True)
    parser.add_option("-x", "--pdb_repository",
                      dest="pdbrep", type='string',
                      help="""Directory containing PDB files. The default
                              value is """ + pdb, default=pdb,
                      metavar="DIR")
    (opts, args) = parser.parse_args()

    if len(args) != 0:
        parser.error("Incorrect number of arguments")

    if not opts.moddir or not opts.native or \
       not opts.natchn or not opts.pdbrep:
        parser.error("Essential arguments not specified")

    for modf in os.listdir(opts.moddir):
        h,t = os.path.split(modf)
        r,e = os.path.splitext(t)
        s = calculate_no(opts.pdbrep, opts.native, opts.natchn, r, '', '')
        print s


if __name__ == "__main__":
    main()
