import unittest
import os
import modpipe.test
import modpipe.binaries
import subprocess

class MkSpazTests(modpipe.test.TestCase):

    def test_mkspaz(self):
        """Check mkspaz from SPASM"""
        expected_lines = [' Nr of atoms : (       1959)', '',
                          ' Nr of residues found   : (        251)',
                          ' Nr of residues written : (        249)']
        binary = modpipe.binaries.get_spasm('mkspaz')
        spasm = 'foo.spasm'
        p = subprocess.Popen([binary], stderr=subprocess.PIPE,
                             stdout=subprocess.PIPE, stdin=subprocess.PIPE)
        print >> p.stdin, "%s\n../db/pdb/pdb1apx.ent\n" % spasm
        p.stdin.close()
        lines = p.stdout.readlines()
        errlines = p.stderr.readlines()
        self.require_clean_exit(p)
        os.unlink(spasm)
        self.assertEqual(len(errlines), 1)
        self.assertEqual([line.rstrip('\r\n ') for line in lines[-28:-24]],
                         expected_lines)

if __name__ == '__main__':
    unittest.main()
