import unittest
import os
import modpipe.test
import modpipe.binaries
import subprocess

class SegTests(modpipe.test.TestCase):

    def test_seg(self):
        """Check SEG"""
        expected_codes = ['1apxA', '1apxB', '1apxC', '1apxD', '1ecsA',
                          '1ecsB', '1llp', '1n8yC', '1sj2A', '1sj2B']
        binary = modpipe.binaries.get_seg()
        p = subprocess.Popen([binary, '../db/test-pdb.fsa', '-q'],
                             stdout=subprocess.PIPE)
        codes = []
        for line in p.stdout:
            if line.startswith('>'):
                codes.append(line[1:].rstrip('\r\n'))
        self.assertEqual(codes, expected_codes)
        self.require_clean_exit(p)

if __name__ == '__main__':
    unittest.main()
