# This file is part of ModPipe, Copyright 1997-2020 Andrej Sali
#
# ModPipe is free software: you can redistribute it and/or modify
# it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with ModPipe.  If not, see <http://www.gnu.org/licenses/>.

"""Handling of Modeller profiles"""

import modpipe
import modpipe.sequence

class ProfileParser(object):
    """Parser for Modeller profile files"""

    def read(self, fh):
        """Read sequences from the given stream in profile format. A list of
           the sequences is returned, as :class:`Sequence` objects."""
        for line in fh:
            if not line.startswith('#'): # ignore comment lines
                spl = line.split()
                seq = modpipe.sequence.Sequence()
                seq.code = spl[1]
                if spl[2] == 'S':
                    seq.prottyp = 'sequence'
                else:
                    seq.prottyp = 'structureX'
                seq.iteration = int(spl[3])
                seq.db_length = int(spl[4])
                seq.target_start = int(spl[5])
                seq.target_stop = int(spl[6])
                seq.db_start = int(spl[7])
                seq.db_stop = int(spl[8])
                seq.n_eqvpos = int(spl[9])
                seq.seqid = float(spl[10])
                seq.evalue = float(spl[11])
                seq.primary = spl[12]
                yield seq
