#!/usr/bin/python3

import re
from urllib.request import urlopen


modeller_version = '9.22'
urltop = 'https://salilab.org/modeller/%s/manual' % modeller_version


def get_node_range():
    linkre = re.compile('HREF="node(\d+)\.html')
    with urlopen('%s/node1.html' % urltop) as fh:
        nodes = linkre.findall(fh.read().decode('utf-8'))
    return (2, max(int(x) for x in nodes) + 1)


def get_link_targets():
    meths = {}
    classes = {}
    methre = re.compile('<A NAME="CMD:(\w+)\.\w+"><\/A><A NAME="\d+"><\/A><TT>(\w+)\(')
    classre = re.compile('<A NAME="CMD:[^.]+"><\/A><A NAME="\d+"><\/A><TT>(\w+)\(')
    for node in range(*get_node_range()):
        with urlopen('%s/node%d.html' % (urltop, node)) as fh:
            url = fh.read().decode('utf-8')
        base = 'node%d.html' % node
        for cls in classre.findall(url):
            classes[cls] = base
        for (cls, meth) in methre.findall(url):
            if cls == 'sequencedb':
                cls = 'sequence_db'
            meths[(cls, meth)] = base
    return meths, classes


def main():
    meths, classes = get_link_targets()
    print("# Sphinx inventory version 1")
    print("# Project: modeller")
    print("# Version: %s" % modeller_version)
    for (key, val) in classes.items():
        print("%s class %s" % (key, val))
    for (key, val) in meths.items():
        print("%s.%s method %s" % (key[0], key[1], val))


if __name__ == '__main__':
    main()
