#include "lib/Include_basic.h"
//#include "Prot.h"
#include "pdb_atom.h"
#include "pdb_res.h"
#include "seq.h"
#include <iostream>
#include <unistd.h>

using namespace std;

#ifndef _bsp_


class set
{
  friend class site;
 public:
  int n;
  int *v;
 public:
  set(void ){    n = 0;}
  ~set(void ){  delete v; }
  void init(int length){ v = new int[length]; }
  void determine_from_flag(int f, int flag[]);
  int  number(void){ return n;}
  int  random(void);
} ;

#define ENERGY_OVERLAP 0 // Overlap used to test the method and detect bugs
#define ENERGY_DIST    1 // Geometric element
#define ENERGY_CNS     2 // Results of blast
#define ENERGY_EPT     3 // Obtained by delphi
#define ENERGY_TEMP    4 // Temperature from pdb file not yet ready because not contained in .sol
#define ENERGY_PROTR   5 // Protrusion
#define ENERGY_CONVEX  6 // Convexity
#define ENERGY_HYDRO   7 // Hydro

#define ENERGY_MAX     8 //number of elements


class site{
 public:
  int *flag_patch;
  set core;
  set surf;
  set patch;
  char *seq;
 public:
  double G;
  double GG[ENERGY_MAX];
  double GZ[ENERGY_MAX];
  double GW[ENERGY_MAX];
  
  //-str cons
  double inf_patch;
  // -- conservation
  int cns_nseq;
  double cns_patch;
  double cns_patch_std;
  double cns_surf;
  double cns_surf_std;
  double cns_core;
  double cns_core_std;
  // -- res ept
  double ept_patch;
  double ept_patch_std;
  double ept_surf;
  double ept_surf_std;
  double ept_core;
  double ept_core_std;
  //--geometry
  double dist_ave;
  double dist_max;
  //--rigidity
  double temp_patch;
  double temp_patch_std;
  //-- hydro miller
  double hydro;
  // -- atoms
  int num_O;
  int num_C;
  int num_N;
  int num_tot;
  int num_exposed;
  int num_buried;
  int n20;
  int n21;
  int n22;
  //--protrusion
  int nres_protr;
  int nres_cavity;
  int overlap_lig;

 	public:
  // --- ROTINES
  	site( void ){ }//cout <<"Site created\n";}
  	void copy( const site &old_site );
  	void difference( const site &old_site, set *set ); 
  	void read_standard(char file[]);
  	void read_ash_format(char file[], prot_res *pr);
  	void inherite_ligand(prot_res *pr);
	void update_patch( );
  	void create_patch( prot_res *pr, int num_of_res);
  	void start_residue( prot_res *pr);  
  	void create_core(  prot_res *pr);
  	void mutate_patch( prot_res *pr  );  
  	void add_residue( prot_res *pr  );
  	void remove_residue( );
  	void remove_residue_nobreak(prot_res *pr);
  	int destroy_patch(prot_res *pr);
  	void  optimize( prot_res *pr );
  // -- SCORE & STATISTICS
  	void score( prot_res *pr );
  	void score_all( prot_res *pr);
  //void statistics( prot_res *pr );
  // -- SCORE FUNCTIONS
  	double score_overlap( prot_res *pr );   // 0
  	double score_dist( prot_res *pr );      // 1
  	double score_cns( prot_res *pr );       // 2
  	double score_ept( prot_res *pr );       // 3
	double score_charge_density( prot_res *pr );      // 3
  	double score_temp_exp( prot_res *pr );      // 4
  	double score_protrusion( prot_res *pr ); // 5
  	double score_convexity( prot_res *pr );  // 6
  	double score_hydro_miller(  prot_res *pr, int debug ); // 7

  	double score_access( prot_res *pr );
  	void score_natm( prot_res *pr );
  	void score_inf( prot_res *pr );

  	void write(char file[]);

  	void fprintf_statistics(FILE *fp);
  	void fprintf_flag( FILE *fp);
  	void fprintf_nres( FILE *fp);
  	void fprintf_GG( FILE *fp);
  	void fprintf_GZ( FILE *fp);
  	void fprintf_GW( FILE *fp);
  	void fprintf_energy( FILE *fp );
	void fprintf_all(FILE *fp);
};


// ------------- EXTERN --------------
extern int    SIZE_AVE;
extern int    SIZE_STD;
extern int    LOG  ;
extern int    N_STEP    ;
extern int    NMC_MAX   ;
extern int    SCORE_FLAG;
extern double TEMP      ;  // Temperature
extern double TEMP_FCTR ;  // Temperature
extern double WEIGHT[]     ;  // Weight for conservation parameter
extern double WEIGHT_AVE[]     ;  // Weight for conservation parameter
extern double WEIGHT_STD[]     ;  // Weight for conservation parameter
extern double GG_PROTEIN_AVE[]     ;  
extern double GG_PROTEIN_STD[]     ;  


extern int CORE;
extern int SURF;
extern int PATCH;

extern int nmc_counter;

extern int DEBUG;
extern FILE  *fp_mc1;
extern FILE  *fp_mc2;
extern FILE  *fp_mc3;
extern FILE  *fp_mc4;

extern site Lig;
extern int LENGTH;

#define N_RANDOM_PATCHES 1000
extern double GG_PROTEIN_AVE[];
extern double GG_PROTEIN_STD[];

//extern class prot_res Prot;
#define _bsp_
#endif
