#include "basic_ad.h"

/*----------------------------------------------------
    ALLOCAZIONE DINAMICA VECTORS
----------------------------------------------------*/


/*-----------------------------
      two index matrices
--------------------------------*/

int **  alloc_imat(int n, int m)
{

  int ** mat = new int*[n];

  for ( int i=0; i<n; i++){
    mat[i] = new int[m];
  }

  return mat;
}

/*-------------------*/

char **  alloc_cmat(int n, int m)
{

  char ** mat = new char*[n];

  for ( int i=0; i<n; i++){
    mat[i] = new char[m];
  }

  return mat;
}

/****************/

double **  alloc_dmat(int n, int m)
{

  double **  mat = new double* [n];

  for (int i=0;i<n;i++){ 
    mat[i] = new double[m];
  }

  return mat;
}
//--------
void free_imat(int n, int ** mat)
{
  for (int i=0; i<n;i++)  delete []mat[i];
  delete []mat;
  
  mat = NULL;
}
//--------
void free_cmat(int n, char ** mat)
{
  for (int i=0; i<n;i++)  delete []mat[i];
  delete []mat;
  
  mat = NULL;
}
//--------
void free_dmat(int n, double ** mat)
{
  for (int i=0; i<n;i++)  delete []mat[i];
  delete []mat;
  
  mat = NULL;
}
/*------------------------------------
       three index matrices
-----------------------------------*/

int ***  alloc_imat_3d(int n1, int n2, int n3)
{

  int *** mat = new int **[n1];


  for (int i=0; i<n1; i++){ 

    mat[i] = new int *[n2];

    for ( int j=0; j<n2; j++){ 
      mat[i][j] = new int[n3];
    }
  }

  return mat;
}
/**/
char ***  alloc_cmat_3d(int n1, int n2, int n3)
{

  char *** mat = new char **[n1];


  for (int i=0; i<n1; i++){ 

    mat[i] = new char *[n2];

    for ( int j=0; j<n2; j++){ 
      mat[i][j] = new char[n3];
    }
  }

  return mat;
}
/**/
double ***  alloc_dmat_3d(int n1, int n2, int n3)
{

  double *** mat = new double **[n1];


  for   (int i=0; i<n1; i++){ 

    mat[i] = new double *[n2];

    for (int j=0; j<n2; j++){ 
      mat[i][j] = new double[n3];
    }
  }

  return mat;
}
//--------
void free_imat_3d(int n1, int n2, int *** mat)
{
  for (int i=0; i<n1; i++){
    for (int j=0; j<n2; j++){  
      delete []mat[i][j];
    }
    delete []mat[i];
  }
  delete []mat;

  mat = NULL;
}
//--------
void free_cmat_3d(int n1, int n2, char *** mat)
{
  for (int i=0; i<n1; i++){  
    for (int j=0; j<n2; j++){
      delete []mat[i][j];
    }
    delete []mat[i];
  }
  delete []mat;

  mat = NULL;

}
//--------
void free_dmat_3d(int n1, int n2, double *** mat)
{
  for (int i=0; i<n1; i++){
    for (int j=0; j<n2; j++){  
      delete []mat[i][j];
    }
    delete []mat[i];
  }
  delete []mat;

  mat = NULL;
}
/************************************
 *  Allocation for structure mat
 *  Under construction
 ***************************************/
void alloc_struct_dmat(int n, int m, dmat * mat)
{

  mat->n = n;
  mat->m = m;

  mat->mat = new double*[mat->n];

  for (int i=0; i<n; i++){ 
    mat->mat[i] = new double[mat->m];
  }
}

/****/

void alloc_struct_imat(int n, int m, imat * mat)
{

  mat->n = n;
  mat->m = m;


  mat->mat = new int*[mat->n];

  for (int i=0; i<n; i++){ 
    mat->mat[i] = new int[mat->m];
  }
}

/**/

void alloc_struct_dvec(int n, dvec * vec)
{
  vec->n = n;

  vec->vec = new double[vec->n];
}

/**/

void alloc_struct_ivec(int n, ivec * vec)
{
  vec->n = n;

  vec->vec = new int[vec->n];
}

/*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV*/
