/*********************************************************
  CREATED 23 Nov 2000

Contains random funcions from Numerical Recipes (ran3)
and some subroutines using them



*****************************************************************/


#include "basic_ran.h"


long int IDUM = -1;

/* ===================================================================
>	PROGRAMMA PER GENERARE NUMERI CASUALI -- FUNZIONI RAN3 E RAN4
======================================================================
>	ISTRUZIONI PER L'USO -- SCRIVERE:
>
>	long int idum = (-1);     -->INIZIALIZZAZIONE
>
>	main(){
>
>	int dado;
>
>
>	dado=(int) (ran4(&idum)*48);   -->NUMERO CASUALE DADO
>	dado=(int) (ran3(&idum)*48);
==================================================================== */



#define MBIG 1000000000
#define MSEED 161803398
#define MZ 0
#define FAC (1.0/MBIG)
  
double ran3(long *idum)   
{
        static int inext,inextp;
        static long ma[56];
        static int iff=0;
        long mj,mk;
        int i,ii,k;

        if (*idum < 0 || iff == 0) {
                iff=1;
                mj=MSEED-(*idum < 0 ? -*idum : *idum);
                mj %= MBIG;
                ma[55]=mj;
                mk=1;
                for (i=1;i<=54;i++) {
                        ii=(21*i) % 55;
                        ma[ii]=mk;
                        mk=mj-mk;
                        if (mk < MZ) mk += MBIG;
                        mj=ma[ii];
                }
                for (k=1;k<=4;k++)
                        for (i=1;i<=55;i++) {
                                ma[i] -= ma[1+(i+30) % 55];
                                if (ma[i] < MZ) ma[i] += MBIG;
                        }
                inext=0;
                inextp=31;
                *idum=1;
        }
        if (++inext == 56) inext=1;
        if (++inextp == 56) inextp=1;
        mj=ma[inext]-ma[inextp];
        if (mj < MZ) mj += MBIG;
        ma[inext]=mj;
        return mj*FAC;
}
#undef MBIG
#undef MSEED
#undef MZ
#undef FAC

/***************************
It returns:
> 1 if the move is accepted
> 0 otherwise
**************************/
int metrop(double de, double t)
{
  return de<=0.0 || ran3(&IDUM)<exp(-de/t);
}
/**************************************************************/
void ivec_init_random(int length, int max, int vec[])
{
  int i  ;

  for(i=0; i < length; i++){
    vec[i] = (int)(ran3(&IDUM)*max);
  }
}

/*----------------------------------------------------------------
Given a probability vector (0.30,0.25,...), it returns the index to
a component with such probability 
-------------------------------- -------------*/

int dado(int n, double *p)
{
  double tot = 0.0;

  double r = ran3(&IDUM);

  int i=0;

  for(; i < n; i++){
    tot += p[i];
    if(r < tot) break;
  }


  return i;
}
// Uniform distribution in the interval [ave-std,ave+std]
// std is not the standard deviation of this distribution!
double uniform_distribution( double ave, double std){
  double r=ran3(&IDUM);

  return (ave + std*2*(r-0.5));
}

/*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV*/
