/****************************************************************
**  Modified March 2001
**  
**
**  > For glycine CB determined with Park and Levitt procedure
**  
**  pdb.c      ->  main routines
**  pdb_io.c   ->  input output routines
**  pdb_chk.c  ->  checking routines
**  pdb_set.c  ->  auxiliary routines
**  pdb_ss.c   ->  routines for evaluation of secondary structures
***************************************************************/



#include "../lib/Include_basic.h"
#include "seq.h"



#ifndef _load_pdb_

#define NATM_PRES 20
#define NHET 1000       // not water

struct atom {
  int flag;
  double V[3];
};


struct residue  {
  char   stype[4]; // restype -> stype
  char   ctype;    // rescode -> ctype 
  char   num[5];   // serial residue number and code for insertions

  int flag;

  atom CA; 
  atom CB; 
  atom C;   
  atom N; 
  atom O;  

  int    natm;
  char   tatm[NATM_PRES][5];
  double atm[NATM_PRES][3];

  double phi;
  double psi;
};


struct chain{
  char code5[6];
  char id;
  int l;

  char * seq;  
  char * sec_str;

  residue * res;
};

//Only one chain is read
struct pdb{
  struct chain chain;
  int nhet;
  double het[NHET][3];
};

#define _load_pdb_
#endif


//--File pdb_chk.c
void check_chain(chain *chain);
int generate_beta( chain *chain);


//--File pdb_io.c
void write_fsa       (char *file, struct chain *chain);
void write_basic     (char *file, struct chain *chain); // <<<---- !!!
void write_xyz       (char *file, struct chain *chain);
void write_seq       (char *file, struct chain *chain); // <<<---- !!!
void write_amino     (char *file, struct chain *chain);
void write_all_atoms (char *file, struct chain *chain);


//--File pdb_ss.c  (work in progress!!!)
void eval_dangles( pdb *pdb);

