#include "pdb_atom.h"

using namespace std;

// I put here ATOM lines before reading values in C program
char   BUFFER[NROWMAX][NCOLMAX];

/************************************************
   PROTEIN
************************************************/

int read_buffer( char file[], char BUFFER[NROWMAX][NCOLMAX])
{
  char buffer[NCOLMAX];

  FILE *fp = fopen_read (file);

  int natm=0;
  while( fgets(buffer, NCOLMAX, fp) ){
    if( strncmp(buffer, ATOM, 6) == 0){
      strcpy(BUFFER[natm], buffer);  //buffer -> BUFFER
      natm++;
      //printf("%4d %s", natm, buffer);
    }
    else if( strncmp(buffer, END, 3) == 0 ){
      break;
    }
  }
  if(natm >= (NROWMAX-5) ){
    printf("ERRORE BUFFER piccolo: %d %d\n", natm, NROWMAX);
    exit(-1);
  }
  fclose(fp);

	return natm;
}

// Create atom structure from .pdb file

void  prot_atom::create_atom_pdb( char BUFFER[NROWMAX][NCOLMAX])
{
  atm = new atom[natm];

  for( int i=0; i<natm; i++){
    //atm[i].init();
    atm[i].read_pdb(BUFFER[i]);
  }
}

// Create atom structure from .sol file

void  prot_atom::create_atom_sol( char BUFFER[NROWMAX][NCOLMAX])
{
  atm = new atom[natm];

  for( int i=0; i<natm; i++){
    //atm[i].init();
    //cout << i+1<<"\n";
    atm[i].read_pdb(BUFFER[i]);
    atm[i].read_rad_sol(BUFFER[i]);
  }
}

/*************************************************************
  Label SURFACE atoms if exposed area less than cutoff...
  ---
  ********************************************************/
void prot_atom::atom_surface(double cutoff)
{
   for(int i=0; i<natm; i++){
     if( atm[i].sol < cutoff)
       atm[i].surf.surf_flag = 0;
     else      
       atm[i].surf.surf_flag = 1;
   }
}


/*********************************************************
 Nearest neighbors
 --- 
**********************************************************/

void prot_atom::create_nst(double cutoff = 8.0)
{
  int compare_nst(const void *nst1, const void *nst2);

  const double radio = 1.0;
  const double max_dist = 100.0;
  const int max_count = (int)(max_dist/radio);

  struct nst nst0[natm];

  alloc_struct_imat(natm, max_count, &count);
  imat_init( natm, max_count, count.mat, 0);

  for(int i=0; i<natm; i++){
    int n=0;
    for(int j=0; j<natm; j++){
      if(i==j){continue;}
      double distance = dvec_distance(3, atm[i].xyz, atm[j].xyz );

      // ------- RADIAL DISTRIBUTION IN 1 A SHELLS ------ //
      int index = (int)(distance/radio);
      if(index < max_count){ count.mat[i][index]++; }
      //printf("%d %f  %6.2f %6.2f\n", j+1, nst0[n].d, atm[i].xyz[0], atm[j].xyz[0]);

      // ----- NEAREST NEIGHBORS ----- //
      if(  distance < cutoff){
	nst0[n].d = distance;
	nst0[n].i = j;
	n++;
      }
    }
    //cout << i << " "<< n <<"\n";
    //printf("%d %d \n", i+1, n);
    //qsort(nst0, n, sizeof(struct nst), compare_nst );

    // ----- NEAREST NEIGHBORS ----- //
    atm[i].nnst = n;
    atm[i].nst  = new nst[n];
    for(int j=0; j<n; j++){
      atm[i].nst[j].i = nst0[j].i;
      atm[i].nst[j].d = nst0[j].d;
    }
  }
}

// They are identical if dist < 0.01 A
int compare_nst(const void *p1, const void *p2)
{
  struct nst *nst1 = (struct nst*)p1;
  struct nst *nst2 = (struct nst*)p2;

  return (int)((nst1->d - nst2->d)*100);
}


/************************************************
  Create normal
  ----
***********************************************/

void prot_atom::create_normal()
{
  for(int i=0; i<natm; i++){
    dvec_init(3, atm[i].surf.cm, 0.0);
    atm[i].surf.ncm = 0;
    if(atm[i].surf.surf_flag == 0) continue;
    for(int j=0; j<atm[i].nnst; j++){
      int u = atm[i].nst[j].i;
      if(atm[u].surf.surf_flag == 1) continue;
      dvec_sum(3, 1.0, atm[i].surf.cm, 1.0, atm[u].xyz);
      atm[i].surf.ncm++;
    }
  }

  for(int i=0; i<natm; i++){
    dvec_init(3, atm[i].surf.norm, 0.0);
    if(atm[i].surf.ncm != 0){
      atm[i].surf.norm_flag = 1;
      dvec_scal(3, atm[i].surf.cm, 1.0/atm[i].surf.ncm);
      dvec_sum_xyz(3, atm[i].surf.norm, 1.0, atm[i].xyz, -1.0, atm[i].surf.cm);
      dvec_norm(3, atm[i].surf.norm);
    }
    else 
      atm[i].surf.norm_flag = 0;
  }
}

/***********************************************
  PROTUSION
  ---
  Needs count.mat in neraest neighbor
***********************************************/

void prot_atom::atom_determine_protrusion(void){
  //atom_determine_protrusion( 12, 16, 150, 200);
    atom_determine_protrusion( 8, 12, 120, 150);
}

void prot_atom::atom_determine_protrusion(int R1, int R2, int N1, int N2)
{
  for(int i=0; i<natm; i++){
    double x = 0.0;
    for(int j=R1; j<R2; j++){
      x += (double)(count.mat[i][j]);
    }

    if( x <= N1){
      atm[i].protr = 'P';
    }
    else if( x <= N2){ 
      atm[i].protr = 'I';
    } 
    else{
      atm[i].protr = 'C';
    }
    //cout << i+1 << atm[i].protr << "\n";
  }
}

/**************************************************
 ----  WRITE ---
**************************************************/

// Write atom

void prot_atom::write_atom( char file[] )
{
  char buffer[NCOLMAX];

  FILE *fp = fopen_write(file);  
  for(int i=0; i<natm; i++){
    atm[i].print_buffer(buffer);
    fprintf(fp, "%s\n", buffer);
  }
  fclose(fp);
}

void prot_atom::write_nst(char file[])
{
  FILE *fp = fopen_write(file);
  for(int i=0; i<natm; i++){
    fprintf(fp, "%5d  %3d ", i+1, atm[i].nnst);
    for(int j=0; j<atm[i].nnst; j++){
      fprintf(fp, "%5d->%6.3f ", atm[i].nst[j].i,atm[i].nst[j].d);
    }
    fprintf(fp, "\n");
  }
  fclose(fp);
}

void prot_atom::write_count(char file[])
{
  FILE *fp = fopen_write(file);
  for(int i=0; i<natm; i++){
    fprintf(fp, "%5d | %6.3f |", i+1, atm[i].sol);
    for(int j=0; j<count.m; j++){
      fprintf(fp, "%5d ", count.mat[i][j]);
    }
    fprintf(fp, "\n");
  }
  fclose(fp);
}

void prot_atom::write_surf_norm(char file[])
{
  FILE *fp = fopen_write(file);
  for(int i=0; i<natm; i++){
    fprintf(fp,"%5d ", i+1);
    for(int j=0; j<3; j++){ fprintf(fp,"%8.3f ", atm[i].xyz[j]);  }    
    fprintf(fp,"  %d ", atm[i].surf.surf_flag);
    for(int j=0; j<3; j++){ fprintf(fp,"%8.3f ",atm[i].surf.cm[j]);  }    
    fprintf(fp,"  %d ", atm[i].surf.norm_flag);
    for(int j=0; j<3; j++){ fprintf(fp,"%8.3f ",atm[i].surf.norm[j]);  }    
    fprintf(fp,"\n");
  }
  fclose(fp);
}
// -- 
void prot_atom::write_pdb_protrusion( char file[])
{
  int n0=0,n1=0,n2=0;

  for(int i=0; i<natm; i++){

    if( atm[i].protr == 'P'){
      atm[i].temp = 0.0;
      n0++;
    }
    else if( atm[i].protr == 'I'){ 
      atm[i].temp = 1.0;
      n1++;
    } 
    else if( atm[i].protr == 'C'){
      atm[i].temp = 2.0;
      n2++;
    }
    else{
      cerr <<"Errore in write_protrusion atom\n";
      exit(0);
    }
  }

  //printf("NATOM=  %d\n",natm);
  //printf("SURF=   %d\n",n0);
  //printf("MEDIUM= %d\n",n1);
  //printf("CORE=   %d\n",n2);
  //printf("RATIO(n2/n0)=   %f\n",(double)n2/n0);

  write_atom(file);
}

//---

void prot_atom::write_pdb_surf( char file[] )
{
  for(int i=0; i<natm; i++){
    atm[i].temp = (double)atm[i].surf.surf_flag;
  }
  write_atom(file);
}


void prot_atom::write_pdb_norm( char file[] )
{
  char buffer[NCOLMAX];

  FILE *fp = fopen_write(file);  
  for(int i=0; i<natm; i++){
    if(atm[i].surf.surf_flag==1) atm[i].chain = 'C';
    atm[i].print_buffer(buffer);
    fprintf(fp, "%s\n", buffer);
  }

  class atom atm0;
  for(int i=0; i<natm; i++){
    if(atm[i].surf.norm_flag == 0) continue;
    atm0.copy(atm+i);
    atm0.chain = 'B';

    dvec_sum(3, 1.0, atm0.xyz, 1.0, atm[i].surf.norm); 
    atm0.print_buffer(buffer);
    fprintf(fp, "%s\n", buffer);

    dvec_sum(3, 1.0, atm0.xyz, 1.0, atm[i].surf.norm); 
    atm0.print_buffer(buffer);
    fprintf(fp, "%s\n", buffer);

    dvec_sum(3, 1.0, atm0.xyz, 1.0, atm[i].surf.norm); 
    atm0.print_buffer(buffer);
    fprintf(fp, "%s\n", buffer);
  }
  fclose(fp);
}
