#include "pdb.h"

/**********************************************************
 ****
 ****     PRINTING
 ****
 ***********************************************************/

/*--------------------------------------------------
  Print sequence information CA CB coordiantes
  Format:
  --
  LENGTH: 155
  1   %c   %f %f %f   %f %f %f
  2   %c   %f %f %f   %f %f %f
  ...
  155 %c   %f %f %f   %f %f %f
  END
-----------------------------------------------------*/

void write_basic(char *file, struct chain *chain)
{
  FILE *fp = fopen(file,"w");
  fprintf(fp,"LENGTH: %d\n",chain->l);


  for(int i=0; i<chain->l; i++){

    if(chain->res[i].CA.flag != 1 || chain->res[i].CB.flag != 1){ 
      printf("ERROR in print_basic!! flag of res # %s is not one\n",
	     chain->res[i].num);
      //exit(0);
    }

    fprintf(fp, "%4d %c ",i+1, chain->res[i].ctype);

    fprintf_dvec(fp, "%6.1f ", 3, chain->res[i].CA.V);
    fprintf_dvec(fp, "%6.1f ", 3, chain->res[i].CB.V);

    fprintf_n(fp);
  }
  fprintf(fp, "END");
  fclose(fp);
}

// -- Write sequence in fasta format 

void write_fsa(char *file, struct chain *chain)
{
  FILE *fp = fopen(file,"w");
  fprintf(fp,">%s\n", chain->code5);
  fprintf(fp,"%s\n",  chain->seq);
  fclose(fp);
}

// -- Write sequence with pdb number
void write_seq(char *file, struct chain *chain)
{
  FILE *fp = fopen_write(file);

  for(int i=0; i<chain->l; i++){
    fprintf(fp, "%4d %4s %c %s\n",
	    i+1, 
	    chain->res[i].num, 
	    chain->res[i].ctype,
	    chain->res[i].stype
	    );
  }
  fclose(fp);
}

/*-----------------------------------------------------
Print information about amino acids on a single line
------------------------------------------------------*/

void write_amino(char *file, struct chain *chain)
{
  FILE *fp = fopen(file,"w");

  fprintf(fp,"<%s>\n\n",chain->seq);


  for(int i=0; i<chain->l; i++){

    fprintf(fp, "%4d %c %c <%s> <%s> ",i+1, 
	    chain->res[i].ctype, 
	    chain->seq[i],
	    chain->res[i].stype,
	    chain->res[i].num);
    if(chain->res[i].C.flag == 1){ 
      fprintf(fp," N: ");
      fprintf_dvec(fp, "%6.1f", 3, chain->res[i].N.V);
    }
    if(chain->res[i].C.flag == 1){ 
      fprintf(fp," CA: ");
      fprintf_dvec(fp, "%6.1f", 3, chain->res[i].CA.V);
    }
    if(chain->res[i].C.flag == 1){ 
      fprintf(fp," C: ");
      fprintf_dvec(fp, "%6.1f ", 3, chain->res[i].C.V);
    }
    if(chain->res[i].CB.flag == 1){ 
      fprintf(fp," CB: ");
      fprintf_dvec(fp, "%6.1f", 3, chain->res[i].CB.V);
    }
    fprintf_n(fp);
  }
  fclose(fp);
}
/*-----------------------------------------------------
Print information about amino acids on a single line
------------------------------------------------------*/

void write_all_atoms(char *file, chain *chain)
{
  FILE *fp = fopen(file,"w");

  fprintf(fp,"General data:\n");
  fprintf(fp, "code5: <%s> chain %c\n\n", 
	  chain->code5, chain->id);

  fprintf(fp,"Sequence\n");
  fprintf(fp,"<%s>\n\n",chain->seq);

  fprintf(fp,"ATOMIC COORDIANTES SECTION\n");
  for(int i=0; i<chain->l; i++){
    fprintf(fp, "## RES %4d %c %c <%s> <%s>   Natm: %d\n",i+1, 
	    chain->res[i].ctype, 
	    chain->seq[i],
	    chain->res[i].stype,
	    chain->res[i].num,
	    chain->res[i].natm);
    for(int j=0; j<chain->res[i].natm; j++){
      fprintf     ( fp,"  %2d  %5s ", j+1,   chain->res[i].tatm[j]);
      fprintf_dvec( fp, "%6.1f", 3, chain->res[i].atm[j]);
      fprintf     ( fp, "\n");
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}


/******************************************************************
 ****
 ****     GENERATE BETA CARBONS
 ****
 *****************************************************************

  genera le coordinate di CB per il residuo j
  necessario conoscere coordinarte CA residuo j, j-1 e j+1

  CB[j] = CA[j] + vec

  vec = R(cos b x + sin b y)

    x = r1+r2, 
    y = r1^r2 e 

  r1=CA[j]-CA[j-1], 
  r2=CA[j]-CA[j+1]
********************************************************************/

int generate_beta(chain *chain)
{

  double x[3],y[3];
  double r1[3],r2[3];
  double vec[3];

  const double RADIUS = 1.55;
  //const double ANGLE  = 0.66;
  const double COSB   = 0.790;
  const double SINB   = 0.613;


  for(int j=0 ; j < chain->l ; j++){

    if(chain->res[j].ctype == 'G'){

      if(j == 0 && j == chain->l-1){
	dvec_cp(3, chain->res[j].CB.V, chain->res[j].CA.V);
      }
      else{
	dvec_sum_xyz(3, r1, 1.0, chain->res[j].CA.V, -1.0, chain->res[j-1].CA.V);
	dvec_sum_xyz(3, r2, 1.0, chain->res[j].CA.V , -1.0, chain->res[j+1].CA.V);
      
	dvec_sum_xyz(3, x, 1.0, r1, 1.0, r2);
	dvec_norm(3,x);

	dvec_vectorial(y,r1,r2);
	dvec_norm(3,y);
  
	dvec_sum_xyz(3, vec, RADIUS*COSB, x, RADIUS*SINB, y);
	dvec_sum_xyz(3, chain->res[j].CB.V, 1.0, chain->res[j].CA.V, 1.0, vec);
      }
      chain->res[j].CB.flag = 1;
    }
  }
  
  return(1);
}


/****************************************************
 ****
 ****   CHECKING
 ****
 **************************************************/

void check_pdb(chain * chain)
{
  int check_peptidic_bond (FILE * fp, struct chain * chain);
  int check_sequence      (FILE * fp, struct chain * chain);
  int check_backbone      (FILE * fp, struct chain *chain);


  FILE *fp = stdout;

  printf( "Check_pdb: verifying retrieved data.\n\n" );

  printf( "\n##### Length : %d Filename %s \n\n", chain->l, chain->code5 );

  int chk_pb = check_peptidic_bond(fp, chain);  
  int chk_b  = check_backbone(fp, chain);
  int chk_s  = check_sequence(fp, chain);

  printf( "%s  %4d  %2d %2d %2d\n", chain->code5, chain->l, chk_pb, chk_s, chk_b);
}



/*--------------------------------------------------------
   It controls if the peptidic bond is a "peptidic bond"
  -------------------------------------------------------*/

int check_peptidic_bond(FILE *fp, struct chain * chain)
{
  int i;

  int chk = 0;

  double x[3], dist;
  


  for(i=0; i< (chain->l - 1); i++){ 

    if(chain->res[i].C.flag == 1 && chain->res[i+1].N.flag == 1){

      dvec_sum_xyz(3, x, 1.0, chain->res[i].C.V, -1.0, chain->res[i+1].N.V);

      dist = dvec_length(3,x);

      if(dist > 2.0){

	chk++ ;

	fprintf(fp, "Pdb n.: <%s>   C[%3d]--N[%3d]  --> %6.2f  ",
		chain->res[i].num, i+1, i+2, dist);
	fprintf_dvec(fp, "%6.1f",3, chain->res[i].C.V);
	fprintf_c(fp, 3,' ');
	fprintf_dvec(fp, "%6.1f",3, chain->res[i+1].N.V);
	fprintf_n(fp);
      }
    }
    else{

      chk++ ;

      fprintf(fp, "Pdb n.: <%s>    C_flag[%3d]:%d  N_flag[%3d]:%d\n",
	      chain->res[i].num,
	      i+1, chain->res[i].C.flag,
	      i+2, chain->res[i+1].N.flag);
    }
  }

  return chk ;
}

/*---------------------------------------------------------------
Check backbone atom and CB
----------------------------------------------------------*/

int check_backbone(FILE *fp, chain *chain)
{
  int chk = 0;

  for(int i=0; i<chain->l; i++){
    if(chain->res[i].N.flag == 0){ 
      chk++;
      fprintf(fp, "Pdb n.: <%s>   Missing N \n", chain->res[i].num);
    }
    if(chain->res[i].CA.flag == 0){
      chk++;
      fprintf(fp, "Pdb n.: <%s>   Missing CA\n", chain->res[i].num);
    }
    if(chain->res[i].C.flag == 0){
      chk++;
      fprintf(fp, "Pdb n.: <%s>   Missing C \n", chain->res[i].num);
    }
    if(chain->res[i].O.flag == 0){
      chk++;
      fprintf(fp, "Pdb n.: <%s>   Missing O \n", chain->res[i].num);
    }
    if(chain->res[i].CB.flag == 0 && chain->res[i].ctype != 'G'){
      chk++;
      fprintf(fp, "Pdb n.: <%s>   Missing CB \n", chain->res[i].num);
    }
  }

  return chk;
}

/*--------------------------------------------------------------
Check sequence
  --------------------------------------------------------------*/

int check_sequence(FILE * fp, chain * chain)
{
  int chk = 0;

  int * seq =  new  int[chain->l];

  conv_cs_is(chain->l, seq, chain->seq);

  for(int i=0; i<chain->l; i++){

    if( seq[i] >= NAMINO){

      chk++;

      fprintf(fp, "\nAhh: %d %c\n", i+1, chain->seq[i]);
    }    
  }

  return chk;
}


/*VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV*/
