#include "Include_basic_local.h"
//#include "seq.h"
#include "pdb_atom.h"
#include "seq.h"

#include <fstream>

#ifndef _pdb_res_

// -------------
//   RESIDUE
// -------------


struct surf
{
  int    nb, ne;          //----number of exposed/buried atoms
  double vb[3], ve[3];    //----center of mass of exposed/buried atoms
  int *ab, *ae;           //--list of exposed/buried atoms
  double norm[3];
  double div;
};

struct nst_res 
{
  int n;
  int *v;
};

class res
{
  friend class prot_res;
  friend class site;
  friend class lig;
 private:
  int natm;
  class atom **atm;
  int num;
  char name[4];
  char chain;
  char icode;
  struct surf surf;
  struct nst_res nst;
  double seq_cns;
  double str_cns;
  double surf_ept;
  double temp_exp;
  double charge_exp;
  double psa;
  char protr;
 public:
  	res(){ 
  		natm = 0; 
		charge_exp = 0.0;
		temp_exp = 0.0;
		psa = 0.0;
	}
};




class prot_res
{
  friend class site;
  friend class lig;
 public:
  int nres;
  int cns_nseq;
  int *real_patch;
 private:
  class  res *res;
  char   *cseq;
  int    flag_surf;
  int    flag_nst;
  int    flag_dmap1;
  double **dmap1;
  int    flag_dmap2;
  double **dmap2;
 private:
  int    flag_imap;
  int    **imap;

 public:

  prot_res(){
    nres=0;
    cns_nseq=0;
    flag_surf  = 0;
    flag_nst   = 0;
    flag_dmap1 = 0;
    flag_dmap2 = 0;
    flag_imap  = 0;
  }
  int number_of_res(){return nres;}
  void create_res( prot_atom *pa);
  void read_conservation(char file[]);
  void read_real_patch(char file[]);
  void read_str_conservation(char file[]);
  void read_surf_ept(char *file);
  //  Residues: interacting point
  void create_surfers( );
  void create_dmap1();
  void create_dmap2();
  void create_nst_dmap2(double dist);
  void create_imap();
  void breadth_first_search(int u, int *dist);
  void evaluate_divergence();
  void determine_protrusion( prot_atom *pa);
	void calculate_charge_exposed();
	void calculate_temp_exposed();
	void calculate_psa();

  // Check & write
  void write_res( char file[]);
  void write_rprotr ( char file[]);
  void read_rprotr  ( char file[]);
  void write_surfers(char file[]);
  void write_nn_list(char *file);
  void write_dmap( char *file, int num);
  void read_dmap2(char *file, int debug);
  void write_imap(char *file);

  void write_pdb_divergence(char *file, prot_atom *pa);
  void write_pdb_protruding(char *file, prot_atom *pa);
  void write_pdb_random_residue(char *file, prot_atom *pa);
  void write_pdb_resnorm(char *file, prot_atom *pa);

  void rasmol_exposed_residues();
  void rasmol_surfers( char *file, double sol);
  void rasmol_nn_list(char *file, char str[]);
};


#define _pdb_res_
#endif
