#include "bsp.h"


ATTENZIONE CONTIENE ANCORA LE SUBROUTINE
PER CONNECTED SITE AND....
IN TE NEW VERSION ADD RESIDUE AND REMOVE RESIDUE
HAVE BEEN SIMPLIFIED


/******************************************************
 -------------     MUTATION    ------------------------
*******************************************************/
// Generate a random binding site with two properties:
// 1) contiguity
// 2) non-core residues
//
//  0 -> core
//  1 -> surface
//  2 -> binding site
// Create site
void create_site(struct site *site)
{
  site->flag = new int[LENGTH];
  site->core.v = new int[LENGTH];
  site->surf.v = new int[LENGTH];
  site->site.v = new int[LENGTH];
}

// Copy site
void cp_site(struct site *site2, struct site *site1)
{
  for(int i=0; i<LENGTH; i++){
    site2->flag[i] = site1->flag[i];
  }
  site2->G  = site1->G;
  site2->G1 = site1->G1;
  site2->G2 = site1->G2;
}
// Create core
void create_core(struct site *site)
{
  for(int i=0; i<LENGTH; i++){    // distinguish between core and surface
    if( Prot.nn[i].n == 0 ){
      site->flag[i] = CORE;
      if( Prot.surf[i].ne != 0){
	printf("ERROR: All the residues have to have a nn!\n");
	printf("%d %d %d\n", i+1, Prot.nn[i].n, Prot.surf[i].ne);
	exit(0);
      }
    }
    else{
      site->flag[i] = SURF;
    }
  }

  composition_site(site);
  printf("    N. of core residues: %d\n", site->core.n);
}

// Initialize site
void init_site(struct site *site, FILE *fp)
{
  int res = start_residue(site);

  if(res < 0 || res>=LENGTH ){
      fprintf(stderr, "Error in init_site 1 (res=%d)\n",res);
  }
  site->flag[res] = SITE;

  for(int j=1; j< SITE_SIZE; j++){
    res = add_residue(site);
    if(res < 0 || res>=LENGTH ){
      fprintf(stderr, "Error in init_site 2 (res=%d)\n",res);
    }
    site->flag[res] = SITE;
  }

  check_site(site,fp);
}

int start_residue(struct site *site)
{
  int set[LENGTH];
  int nset = determine_set(SURF, site->flag, set);
  int nr = (int)(ran3(&IDUM)*nset);  // a random residue on the surface

  if(nr == 0){ fprintf(stderr, "(res=%d) (nset=%d)\n", nr,nset); }

  return set[nr];
}

// MUTATE site
//

void mutate_site(struct site *site, FILE *fp)
{
  int res1 = add_residue(site); //ADD
  site->flag[res1] = SITE;

  int res2 = remove_residue(site); //REMOVE
  site->flag[res2] = SURF;

  check_site(site,fp);

  fflush(fp);
}

void check_site(struct site *site, FILE *fp)
{
  composition_site(site);
  fprintf(fp,"%3d + %3d + %3d = %3d\n", site->core.n, site->surf.n, site->site.n,
	  site->core.n + site->surf.n + site->site.n);
}
// Check site
void composition_site(struct site *site)
{
  site->core.n = determine_set(CORE, site->flag, site->core.v);
  site->surf.n = determine_set(SURF, site->flag, site->surf.v);
  site->site.n = determine_set(SITE, site->flag, site->site.v);
}

//Determine set
int determine_set(int f, int flag[], int set[])
{
  int nset = 0;
  for(int i=0; i<LENGTH; i++){
    if( flag[i] == f ){
      set[nset] = i;
      nset++;
    }
  }
  //printf("nset %d\n", nset);
  return nset;
}

//----ADD---RESIDUE---------------------
// Determine set of n.n. to the patch
// Return negative values if no n.n are found
int add_residue( struct site *site)
{
  int set[LENGTH];
  int n = determine_nn_site( site, set);
  if(n==0){    return -1;  }

  int nr = (int)(ran3(&IDUM)*n);

  return set[nr];
}

int determine_nn_site(struct site *site, int set[])
{
  int nset=0;
  for(int i=0; i<LENGTH; i++){
    if(site->flag[i] == SITE){
      for(int j=0; j< Prot.nn[i].n; j++){
	int k = Prot.nn[i].v[j];
	if( site->flag[k] == SURF){
	  set[nset] = k; 
	  nset++;
	}
      }
    }
  }
  return nset;
}
//-----REMOVE----RESIDUES------------
//
int remove_residue( struct site *site)
{
  int set[LENGTH];
  int nset = determine_set( SITE, site->flag, set);

  if(nset == 0) return -1;

  int nr = (int)(ran3(&IDUM)*nset);  

  return set[nr];
}

/*****************************************************
 *** This part of the code is an old version.
 *** It checks alwaysif the site is connected.
 *****************************************************/

// MUTATE SITE CONNECT
// 1. Add residue
// 2. Remove residue connect
// 3. Check site
void mutate_site_connect(struct site *site, FILE *fp)
{
  int res1 = add_residue(site); //ADD
  if(res1<0 || res1 >= LENGTH){
    fprintf(stderr, "Errore res1= %d\n", res1);
    exit(0);
  }
  if(site->flag[res1]==SITE){
    fprintf(stderr, "Errore flag[res1]= %d\n", site->flag[res1]);
    exit(0);
  }

  site->flag[res1] = SITE;

  int res2 = remove_residue(site); //REMOVE

  if(res2<0 || res2 >= LENGTH){
    fprintf(stderr, "Errore n2= %d\n", res2);
    exit(0);
  }
  if(site->flag[res1]==SURF){
    fprintf(stderr, "Errore flag[res1]= %d\n", site->flag[res2]);
    exit(0);
  }
  site->flag[res2] = SURF;

  check_site(site,fp);


  fflush(fp);

  if(site->core.n + site->surf.n + site->site.n != LENGTH){
    fprintf(stderr, "Error in composition_site\n");
    fprintf(stderr, "%d %d %d %d\n", site->core.n, site->surf.n , site->site.n , LENGTH);
    exit(0);
  }
  if(connected_site(site->site.n, site->site.v, Prot.nn) > 0){
    fprintf(stderr,"Error in mutate_site\n");
    exit(0);
  }
}
//-----REMOVE----RESIDUES------------
// 1. Set of b.s residues
// 2. Try to remove one
// 3. Accept if b.s. still contigous
// 4. Otherwise repeat cycle 
int remove_residue_connect( struct site *site)
{
  int flag2[LENGTH];
  for(int i=0; i<LENGTH; i++){
    if( site->flag[i] == SITE) flag2[i] = 1;
    else flag2[i] = 0;
  }
  int set[LENGTH];
  int nset2;
  int set2[LENGTH];
  int nset = determine_set( 1, flag2, set);

  int nr = (int)(ran3(&IDUM)*nset);

  for(int i=0; i<nset; i++){
    int j = (nr+i)%nset;
    //printf("%2d %2d %2d\n", i+1, j, nset);
    flag2[set[j]] = 0;
    nset2 = determine_set( 1, flag2, set2);
    if( connected_site(nset2, set2, Prot.nn) == 0 ) return set[j];
    flag2[set[j]] = 1;
  }

  return -1;
}

// check if remove_connected is possible
int check_remove(struct site *site, FILE *fp)
{
  int flag2[LENGTH];
  for(int i=0; i<LENGTH; i++){
    if( site->flag[i] == SITE) flag2[i] = 1;
    else flag2[i] = 0;
  }

  int set[LENGTH]; 
  int set2[LENGTH]; 
  int nset = determine_set( 1, flag2, set);

  int n1=0;
  int n2=0;

  for(int i=0; i<nset; i++){
    flag2[set[i]] = 0;
    int nset2 = determine_set( 1, flag2, set2);  
    if( connected_site(nset2, set2, Prot.nn) == 0 ) n1++;
    else  n2++;
    flag2[set[i]] = 1;
  }
  //fprintf(stdout, "(%2d=%2d+%2d)\n", nset, n1, n2);

  return n2; 
}


//------CONTIGUOS-----SITE------
// return 0 if connected
int connected_site(int n1, int set1[], struct nn_list *nn)
{
  int flag[LENGTH];
  ivec_init(LENGTH,flag,0);

  for(int i=0; i<n1; i++){
    flag[set1[i]] = 1;
  }

  int n2=1;
  int set2[LENGTH];
  set2[0] = set1[0];
  flag[set1[0]] = -1;

  for( int i = 0; i<n2; i++){
    int k1 = set2[i];
    for(int j=0; j<nn[k1].n; j++){
      int k2 = nn[k1].v[j];
      if(flag[k2] == 1){
	flag[k2] = -1;
	set2[n2] = k2;
	n2++;
      }
    }
  }
  if(n2>n1){
    fprintf(stderr, "Error in function connected_site n1= %d n2= %d\n",n1, n2);
    exit(0);
  }

  return (n1-n2);
}

