/*******************************************************************
 *  BINDING SITE PREDICTION PROGRAM
 *
 *  Input: features (.cns,...)
 *  Output: files con binding sites (1,0)
 *
 *  Descritpion: this program
 *
 *
 *
 *
 ********************************************************************/
#include "protrusion.h"

int    SIZE_AVE  = 14;
int    SIZE_STD  = 3;
int    LOG       = 1;
int    N_STEP    = 0;
int    NMC_MAX   = 1;
double TEMP      = 0.1;  // Temperature
double AACCESS   = 2.0;  // Accessibility in Angstrom square
double NN_DIST   = 6.0;  // Cutoff for nearest neighbour


int    LENGTH;

int DEBUG = 0;



// Options
char    Sol_file[1000];

char Usage[1000];

prot_atom PA;
prot_res PR;


/*********************************************************************
 *****************     MAIN    ***************************************
 *********************************************************************/


int main(int argc, char *argv[])
{
  void options();
  //ios::sync_with_stdio();

  if(DEBUG>1) printf("Going to read sol...\n");

  options();
  get_options(argc, argv, 0);

  PA.read_buffer( Sol_file );
  PA.create_atom_sol( );
  PA.atom_surface(AACCESS);
  PA.create_nst(NN_DIST);
  PA.write_count("pdb_atom_count.dat" );
  PA.atom_determine_protrusion();
  PA.write_pdb_protrusion("pdb_atom_protr.pdb" ); 
  PA.write_atom("pdb_atom.dat" );


  PR.create_res(&PA);
  PR.create_surfers();
  PR.create_dmap2();
  PR.create_nst_dmap2(6.0);
  PR.determine_protrusion(&PA);

  PR.write_rprotr("pdb_rprotr.dat");   

  PR.write_res("pdb_res.dat");
  PR.write_dmap("pdb_dmap2.dat", 2);
  PR.write_nn_list("pdb_nn_list.dat");
  PR.write_pdb_protruding("pdb_res_protr.pdb", &PA);
  
  LENGTH = PR.number_of_res();
  if(DEBUG>0)   printf("LENGTH %d \n",LENGTH);
}

/*-------------------------------------------------------------
  --                OPTIONS ROUTINE
  --------------------------------------------------------------*/

void options()
{
  get_options_str( Sol_file,  "-sol_file",    "", "" );
}
