/**************************************************
Advanced operations on vectors and matrix

entropy      -> defined as \sum p * log p
hamming_succ -> the number of matches divided by the length
max          -> the maximum value
amax         -> the maximum absolute value 
stat         -> evaluates average and std
*************************************************/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

//#include "Include_all.h"



double dvec_entropy( int l, double *p);
double cvec_hamming_succ( int l, char *s1, char *s2);
double ivec_hamming_succ( int l, int *s1,  int *s2);
void   cvec_composition( int l, char *s,int n, double *f);

int dvec_max(int l, double * v);// change : return only index
int dvec_min(int l, double * v);
int dvec_amax(int l, double * v);

double dvec_stat(int n, double v[], double * std);

void  dmat_stat(int n, int m, double **mat, double * vec_ave, double * vec_std);

