#include "pdb_atom_aux.h"

/********************************************************
  ONLY ATOM
********************************************************/


void atom::read_pdb( char buffer[]){
  read_anum   (  buffer );
  read_aname  (  buffer );
  read_altloc (  buffer );
  read_resname(  buffer );
  read_chain  (  buffer );
  read_resnum (  buffer );
  read_icode  (  buffer );
  read_xyz    (  buffer );
}


void atom::copy(atom * atm2)
{
  anum    = atm2->anum;
  strcpy(aname, atm2->aname);
  altloc  = atm2->altloc;
  strcpy(resname, atm2->resname);
  chain   = atm2->chain;
  icode   = atm2->icode;
  resnum  = atm2->resnum;
  for(int j=0; j<3; j++ ) xyz[j] = atm2->xyz[j];
  temp    = atm2->temp;
  occup   = atm2->occup;
}

void atom::print_buffer(char buffer[])
{
  for(int j=0; j<NCOLMAX; j++){ buffer[j]=' ';}
  print_atom    ( buffer );
  print_anum    ( buffer );
  print_aname   ( buffer );
  print_altloc  ( buffer );
  print_resname ( buffer );
  print_chain   ( buffer );
  print_icode   ( buffer );
  print_resnum  ( buffer );
  print_xyz     ( buffer );
  print_temp    ( buffer );
  print_occup   ( buffer );
  //printf(" %d -> [%f] \n",i+1, xyz[0]);
  buffer[NCOLMAX-1] = '\0';
}

/*
  -- print on buffer
*/

void atom::print_anum(char buffer[]){
  char aux[30];
  sprintf( aux, "%5d", anum);
  strncpy( buffer+6, aux, 5);
}
void atom::print_resnum(char buffer[]){
  char aux[30];
  sprintf( aux, "%4d", resnum);
  strncpy( buffer+22, aux, 4);
}
void atom::print_xyz(char buffer[]){
  char aux[30];
  sprintf( aux, "%8.3f%8.3f%8.3f", xyz[0], xyz[1], xyz[2]);
  strncpy( buffer+30, aux, 24);
}
void atom::print_occup(char buffer[]){
  char aux[30];
  sprintf( aux, "%6.2f", occup);
  strncpy( buffer+54, aux, 6);
}
void atom::print_temp(char buffer[]){
  char aux[30];
  sprintf( aux, "%6.2f", temp);
  strncpy( buffer+60, aux, 6);
}
void atom::print_icode(char buffer[]){
  buffer[26] = icode;
}
void atom::print_chain(char buffer[]){
  buffer[21] = chain;
}
void atom::print_altloc(char buffer[]){
  buffer[16] = altloc;
}
void atom::print_atom(char buffer[]){
  strncpy( buffer, ATOM,6);
}
void atom::print_aname( char buffer[]){
  strncpy(buffer+12, aname, strlen(aname));
}
void atom::print_resname( char buffer[]){
  strncpy(buffer+17, resname, 3);
}

/*
  -- read from buffer
*/
void atom::read_anum( char buffer[]){
  sscanf( buffer+6,  "%d", &anum);
}
void atom::read_aname( char buffer[]){
  sscanf( buffer+12, "%s", aname);
}
void atom::read_altloc( char buffer[]){
  sscanf( buffer+16, "%c", &altloc);
}
void atom::read_resname( char buffer[]){
  sscanf( buffer+17, "%s", resname);
}
void atom::read_chain( char buffer[]){
  sscanf( buffer+21, "%c", &chain);
}
void atom::read_resnum( char buffer[]){
  sscanf( buffer+22, "%d", &resnum);
}
void atom::read_icode( char buffer[]){
  sscanf( buffer+26, "%c", &icode);
}
void atom::read_xyz( char buffer[]){
  if(sscanf(buffer+30, "%lf %lf %lf", &xyz[0], &xyz[1], &xyz[2]) !=3 ){
    printf("\n ERRORE lettura coordinate atomiche \n");
    printf("%s\n", buffer);
    exit(0);
  } 
} 
void atom::read_temp(char buffer[]){
  sscanf( buffer+60, "%lf", &temp);
}

void atom::read_rad_sol( char buffer[]){
 sscanf( buffer+54, "%lf %lf",&rad, &sol);
}
void atom::read_charge(char buffer[]){
  sscanf( buffer+60, "%lf", &charge);
}

/* 
   -- not object oriented --
 */

void read_anum( char buffer[], int *anum)
{
  sscanf( buffer+6,  "%d", anum);
}

void read_aname( char buffer[], char *aname)
{
  sscanf( buffer+12, "%s", aname);
}

void read_altloc( char buffer[], char *altloc)
{
  sscanf( buffer+16, "%c", altloc);
}

void read_resname( char buffer[], char *resname)
{
  sscanf( buffer+17, "%s", resname);
}

void read_chain( char buffer[], char *chain)
{
  sscanf( buffer+21, "%c", chain);
}

void read_resnum( char buffer[], int *resnum)
{
  sscanf( buffer+22, "%d", resnum);
}

void read_icode( char buffer[], char *icode)
{
  sscanf( buffer+26, "%c", icode);
}

void read_xyz( char buffer[], double xyz[])
{
  if(sscanf(buffer+30, "%lf %lf %lf", &xyz[0], &xyz[1], &xyz[2]) !=3 ){
    printf("\n ERRORE lettura coordinate atomiche \n");
    printf("%s\n", buffer);
    exit(0);
  } 
} 

void read_temp(char buffer[], double *temp)
{
  sscanf( buffer+60, "%lf", temp);
}

void read_sol( char buffer[], double *rad, double *sol)
{
 sscanf( buffer+54, "%lf %lf",rad, sol);
}
