/*********************************************

	   SEQUENCE CONVERSION

**********************************************/

#include "seq.h"


// cls 20
struct aa_cls cls20 ={
  20,
  {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19}
};

// cls 2
/****************************************
0 = classe polari,
1 = classe idrofobici
*******************************************/

struct aa_cls cls2_dill ={
  2,
  {1,0,0,0,1,0,0,0,0,1,1,0,1,1,0,0,0,1,1,1}
};

// cls 3
/***********************************  
0 = classe polari neutri, 
1 = classe idrofobici,
2 = classe polari carichi
****************************************/
struct aa_cls cls3_dill={
  3,
  {1,2,0,2,1,0,2,0,2,1,1,2,1,1,0,0,0,1,1,1}
};

// cls 4
/***********************************  
0 = classe polari neutri, 
1 = classe idrofobici,
2 = classe polari carichi
3 = E,D
****************************************/
struct aa_cls cls4_dill={
  4,
  {1,2,0,3,1,0,3,0,2,1,1,2,1,1,0,0,0,1,1,1}
};
// cls 5
/***********************************  
0 = classe polari neutri, 
1 = classe idrofobici,
2 = classe polari carichi
3 = E,D
4 = A,G
****************************************/
struct aa_cls cls5_dill={
  5,
  {4,2,0,3,1,0,3,4,2,1,1,2,1,1,0,0,0,1,1,1}
};

//cls 6
/***********************************  
0 = classe polari neutri, 
1 = classe idrofobici,
2 = classe polari carichi
3 = E,D
4 = A,G
5 = W,Y,P
****************************************/
struct aa_cls cls6_dill={
  6,
  {4,2,0,3,1,0,3,4,2,1,1,2,1,1,5,0,0,5,5,1}
};

//cls 8 (Pancho)

struct aa_cls cls8_pancho = {
  8,
  {0,5,0,2,1,2,2,0,4,3,3,2,3,3,2,0,5,6,7,3}
};

//12 classi 

struct aa_cls cls12 = {
  12,
  {0,1,2,3,4,2,3,5,6,7,7,1,8,9,10,11,11,9,9,7}
};

//////
const  int nmcls = 8;
  
const struct aa_cls *mcls[nmcls]= 
  {
    &cls2_dill, 
    &cls3_dill, 
    &cls4_dill, 
    &cls5_dill, 
    &cls6_dill, 
    &cls8_pancho, 
    &cls12, 
    &cls20
  };


// freq
double AA_FREQ[] = 
{ 0.083, 0.057, 0.044, 0.053, 0.017, 0.040, 0.062, 0.072, 0.022, 0.052,
  0.090, 0.057, 0.024, 0.039, 0.051, 0.069, 0.058, 0.013, 0.032, 0.066};


/*---------------------------------------------------
  Converts 3 letter representation of amino acid in
  1 letter representation
  ----------------------------------------------------*/

char conv_3lett_1lett(char stype[3])
{
  int i;

  for(i=0; i<NAMINO; i++){
    if (! strncmp( stype, aa_interpreter[i].s, 3))
      return  aa_interpreter[i].c ;
  }
  return 'X';
}

/************************************************************
** Function for converting sequence string in different code
**   1. cs = char_seq; sequence as AKLAAG....
**   2. is = int_seq;  sequence in the format 0,12,17,1,1,...
**
** There are two kinds of function:
**   1. conv_cs_is():  cs->is
**   2. conv_is_cs():  is->cs
************************************************************/

void conv_cs_is(int l, int *is, char *cs)
{
  int i,j;

  for(i=0;i<l;i++){

    is[i]=20;

    for(j=0;j<NAMINO;j++){

      if(cs[i] == aa_interpreter[j].c){
        is[i] = aa_interpreter[j].i;
        break;
      }
    }
  }
}

/****************************/

void conv_is_cs(int l, char *cs, int *is)
{
  int i,j;

  for(i=0;i<l;i++){
    for(j=0;j<NAMINO;j++){
      if(is[i]==20){ 
        cs[i]='X';
        break;
      }
      else if(is[i]==aa_interpreter[j].i){
        cs[i]=aa_interpreter[j].c;
        break;
      }
    }
  }
  cs[l]='\0';
}

/*-------------------------
  fprintf iseq as letters
  -------------------------*/

void fprintf_iseq(FILE *fp, int l, int *seq)
{
  for(int i=0; i<l ; i++){
    fprintf(fp, "%c", aa_interpreter[seq[i]].c);
  }
}

/************************************************
Coarse-graines sequence of type int 0..19 into
*************************************************/

void conv_cs_is_cls(int l, int *is, char *cs, const aa_cls *cls)
{
  static int *is20 = new int[l];

  conv_cs_is( l, is20, cs);

  for(int i=0; i<l; i++){
    is[i] = cls->vec[is20[i]];
  }  
}


/************************************************
Coarse-graines sequence of type int 0..19 into
*************************************************/

void conv_is20_is_cls(int l, int *is, int *is20, const aa_cls *cls)
{
  for(int i=0;i<l;i++){
    is[i] = cls->vec[is20[i]];
  }
}

/********************************************************
Given a number, it returns a pointer to a struct aa_cls
********************************************************/

struct aa_cls *num_to_cls(int ncl)
{
  struct aa_cls *cls;

  switch(ncl){
  case 2:
    cls = &cls2_dill;
    break;
  case 3:
    cls = &cls3_dill;
    break;
  case 4:
    cls = &cls4_dill;
    break;
  case 5:
    cls = &cls5_dill;
    break;
  case 6:
    cls = &cls6_dill;
    break;
  case 8:
    cls = &cls8_pancho;
    break;
  case 12:
    cls = &cls12;
    break;
  case 20:
    cls = &cls20;
    break;
  default:
    printf("Error in seq.c ncl\n");
    exit(0);
  }

  return cls;
}
/********************************************************
Charge cls
********************************************************/

struct aa_cls *name_to_cls(char *name)
{
  struct aa_cls *cls;

  if     ( strcmp(name, "cls2_dill")==0   ) cls = &cls2_dill;
  else if( strcmp(name, "cls3_dill")==0   ) cls = &cls3_dill;
  else if( strcmp(name, "cls4_dill")==0   ) cls = &cls4_dill;
  else if( strcmp(name, "cls5_dill")==0   ) cls = &cls5_dill;
  else if( strcmp(name, "cls6_dill")==0   ) cls = &cls6_dill;
  else if( strcmp(name, "cls8_pancho")==0 ) cls = &cls8_pancho;
  else if( strcmp(name, "cls12")==0       ) cls = &cls12;
  else if( strcmp(name, "cls20")==0       ) cls = &cls20;
  else{
    printf("Error in name for cls\n");
    exit(0);
  }

  return cls;
}
