/****************************************************
NEW VERSION
****************************************************/
#include "./lib/Include_basic.h"
#include "pdb_atom_aux.h"


#define PDB_DIR "/diva1/databases/pdb/uncompressed_files/"
#define PDB_IN  "pdb"
#define PDB_SUF ".ent"


#define NATM_INRES_MAX 20
#define NRES_MAX 10000

#ifndef _pdb_atom_

struct nst{
  int i;
  double d;
};


extern  char   BUFFER[NROWMAX][NCOLMAX];
int  read_buffer( char *file, char buffer[NROWMAX][NCOLMAX]);

/***************************************************************************
  prot contains:
#struct res -> information about atomic coordinates, solvent accessibility 
  for every heavy atom in struct res
#surfers -> information about exposed atoms and surfers (i.e. center
  of mass of exposed residues)
#nearest neighbors list -> two residues are nearest neighbors if at least
  two atoms are less than 6.0A
*******************************************************************************/

class prot_atom{
  friend class prot_res;
 public:
  int    natm;
  class  atom *atm;
  struct imat count;

public:
  prot_atom(){/*cout<<"Create PA\n";*/}
  ~prot_atom(){/*cout<<"Destroy PA\n";*/}
  // - Input
  void  create_atom_pdb( char BUFFER[NROWMAX][NCOLMAX]);
  void  create_atom_sol( char BUFFER[NROWMAX][NCOLMAX]);
  // Atom quantities
  void atom_determine_protrusion();
  void atom_determine_protrusion(int R1, int R2, int N1, int N2);
  void create_nst(double cutoff);
  void atom_surface(double cutoff);
  void create_normal();
  // Check &write
  void write_atom(char *file);
  void write_count(char *file );
  void write_nst(char *file);
  void write_surf_norm(char file[]);
  void write_pdb_protrusion( char file[]);
  void write_pdb_surf(char file[]);
  void write_pdb_norm(char file[]);
};

#define _pdb_atom_
#endif
